/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public class Index {
    private String key;
    private Order order;

    public Index(String key, Order order) {
        this.key = key;
        this.order = order;
    }

    public String key() {
        return this.key;
    }

    public Order order() {
        return this.order;
    }

    public static enum Order {
        ASCENDING(1),
        DESCENDING(-1);

        private int value;

        private Order(int value) {
            this.value = value;
        }

        @JsonValue
        public int value() {
            return this.value;
        }

        @JsonCreator
        public static Order fromInt(int i) {
            switch (i) {
                case 1: {
                    return ASCENDING;
                }
                case -1: {
                    return DESCENDING;
                }
            }
            throw new IllegalArgumentException("Invalid index order");
        }

        @JsonCreator
        public static Order fromString(String name) {
            return Order.valueOf(name.toUpperCase());
        }
    }
}

