/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault.database;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.List;
import org.elastos.hive.connection.NodeRPCConnection;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.exception.AlreadyExistsException;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.NetworkException;
import org.elastos.hive.exception.NotFoundException;
import org.elastos.hive.exception.NotImplementedException;
import org.elastos.hive.exception.ServerUnknownException;
import org.elastos.hive.exception.UnauthorizedException;
import org.elastos.hive.exception.VaultForbiddenException;
import org.elastos.hive.vault.database.CountOptions;
import org.elastos.hive.vault.database.CountParams;
import org.elastos.hive.vault.database.CountResult;
import org.elastos.hive.vault.database.CreateCollectionResult;
import org.elastos.hive.vault.database.DatabaseAPI;
import org.elastos.hive.vault.database.DeleteOptions;
import org.elastos.hive.vault.database.DeleteParams;
import org.elastos.hive.vault.database.FindOptions;
import org.elastos.hive.vault.database.FindResult;
import org.elastos.hive.vault.database.InsertOptions;
import org.elastos.hive.vault.database.InsertParams;
import org.elastos.hive.vault.database.InsertResult;
import org.elastos.hive.vault.database.QueryOptions;
import org.elastos.hive.vault.database.QueryParams;
import org.elastos.hive.vault.database.QueryResult;
import org.elastos.hive.vault.database.UpdateOptions;
import org.elastos.hive.vault.database.UpdateParams;
import org.elastos.hive.vault.database.UpdateResult;

public class DatabaseController {
    private DatabaseAPI databaseAPI;

    public DatabaseController(NodeRPCConnection connection) {
        this.databaseAPI = connection.createService(DatabaseAPI.class, true);
    }

    public void createCollection(String collectionName) throws HiveException {
        try {
            CreateCollectionResult result = (CreateCollectionResult)this.databaseAPI.createCollection(collectionName).execute().body();
            if (!collectionName.equals(result.getName())) {
                throw new ServerUnknownException("Different collection created, impossible to happen");
            }
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 455: {
                    throw new AlreadyExistsException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public void deleteCollection(String collectionName) throws HiveException {
        try {
            this.databaseAPI.deleteCollection(collectionName).execute();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public InsertResult insertOne(String collectionName, JsonNode document, InsertOptions options) throws HiveException {
        return this.insertMany(collectionName, Collections.singletonList(document), options);
    }

    public InsertResult insertMany(String collectionName, List<JsonNode> documents, InsertOptions options) throws HiveException {
        try {
            return (InsertResult)this.databaseAPI.insert(collectionName, new InsertParams(documents, options)).execute().body();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e.getMessage());
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public UpdateResult updateOne(String collectionName, JsonNode filter, JsonNode update, UpdateOptions options) throws HiveException {
        throw new NotImplementedException();
    }

    public UpdateResult updateMany(String collectionName, JsonNode filter, JsonNode update, UpdateOptions options) throws HiveException {
        try {
            return (UpdateResult)this.databaseAPI.update(collectionName, new UpdateParams(filter, update, options)).execute().body();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e.getMessage());
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public int deleteOne(String collectionName, JsonNode filter, DeleteOptions options) throws HiveException {
        throw new NotImplementedException();
    }

    public int deleteMany(String collectionName, JsonNode filter, DeleteOptions options) throws HiveException {
        try {
            this.databaseAPI.delete(collectionName, new DeleteParams(filter, options)).execute().body();
            return 0;
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e.getMessage());
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public long countDocuments(String collectionName, JsonNode filter, CountOptions options) throws HiveException {
        try {
            return ((CountResult)this.databaseAPI.count(collectionName, new CountParams(filter, options)).execute().body()).getCount();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e.getMessage());
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public JsonNode findOne(String collectionName, JsonNode filter, FindOptions options) throws HiveException {
        List<JsonNode> docs = this.find(collectionName, filter, options);
        return docs != null && !docs.isEmpty() ? docs.get(0) : null;
    }

    public List<JsonNode> find(String collectionName, JsonNode filter, FindOptions options) throws HiveException {
        try {
            String filterStr = filter == null ? "" : filter.toString();
            String skip = options != null ? options.getSkipStr() : "";
            String limit = options != null ? options.getLimitStr() : "";
            return ((FindResult)this.databaseAPI.find(collectionName, filterStr, skip, limit).execute().body()).documents();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e.getMessage());
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public List<JsonNode> query(String collectionName, JsonNode filter, QueryOptions options) throws HiveException {
        try {
            return ((QueryResult)this.databaseAPI.query(new QueryParams(collectionName, filter, options)).execute().body()).documents();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e.getMessage());
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }
}

