/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault.backup.credential;

import org.elastos.hive.DataStorage;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.connection.auth.CodeFetcher;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.service.BackupContext;
import org.elastos.hive.vault.backup.credential.LocalResolver;
import org.elastos.hive.vault.backup.credential.RemoteResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialCode {
    private static final Logger log = LoggerFactory.getLogger(CredentialCode.class);
    private String targetServiceDid;
    private String jwtCode;
    private CodeFetcher remoteResolver;
    private DataStorage storage;

    public CredentialCode(ServiceEndpoint endpoint, BackupContext context) {
        this.targetServiceDid = context.getParameter("targetServiceDid");
        RemoteResolver remoteResolver = new RemoteResolver(endpoint, context, this.targetServiceDid, context.getParameter("targetAddress"));
        this.remoteResolver = new LocalResolver(endpoint, remoteResolver);
        this.storage = endpoint.getStorage();
    }

    public String getToken() throws HiveException {
        if (this.jwtCode != null) {
            return this.jwtCode;
        }
        this.jwtCode = this.restoreToken();
        if (this.jwtCode == null) {
            try {
                this.jwtCode = this.remoteResolver.fetch();
            }
            catch (NodeRPCException e) {
                throw new HiveException(e.getMessage());
            }
            if (this.jwtCode != null) {
                this.saveToken(this.jwtCode);
            }
        }
        return this.jwtCode;
    }

    private String restoreToken() {
        return this.storage.loadBackupCredential(this.targetServiceDid);
    }

    private void saveToken(String jwtCode) {
        this.storage.storeBackupCredential(this.targetServiceDid, jwtCode);
    }
}

