/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.service.DatabaseService;
import org.elastos.hive.vault.database.CountOptions;
import org.elastos.hive.vault.database.DatabaseController;
import org.elastos.hive.vault.database.FindOptions;
import org.elastos.hive.vault.database.InsertOptions;
import org.elastos.hive.vault.database.InsertResult;
import org.elastos.hive.vault.database.QueryOptions;
import org.elastos.hive.vault.database.UpdateOptions;
import org.elastos.hive.vault.database.UpdateResult;

class DatabaseServiceRender
implements DatabaseService {
    DatabaseController controller;

    public DatabaseServiceRender(ServiceEndpoint serviceEndpoint) {
        this.controller = new DatabaseController(serviceEndpoint);
    }

    @Override
    public CompletableFuture<Void> createCollection(String name) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.controller.createCollection(name);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> deleteCollection(String name) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.controller.deleteCollection(name);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<InsertResult> insertOne(String collection, JsonNode doc, InsertOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.controller.insertOne(collection, doc, options);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<InsertResult> insertMany(String collection, List<JsonNode> docs, InsertOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.controller.insertMany(collection, docs, options);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Long> countDocuments(String collection, JsonNode query, CountOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.controller.countDocuments(collection, query, options);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<JsonNode> findOne(String collection, JsonNode query, FindOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.controller.findOne(collection, query, options);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<List<JsonNode>> findMany(String collection, JsonNode query, FindOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.controller.find(collection, query, options);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<List<JsonNode>> query(String collection, JsonNode query, QueryOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.controller.query(collection, query, options);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<UpdateResult> updateOne(String collection, JsonNode filter, JsonNode update, UpdateOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.controller.updateOne(collection, filter, update, options);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<UpdateResult> updateMany(String collection, JsonNode filter, JsonNode update, UpdateOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.controller.updateMany(collection, filter, update, options);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> deleteOne(String collection, JsonNode filter) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.controller.deleteOne(collection, filter, null);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> deleteMany(String collection, JsonNode filter) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.controller.deleteMany(collection, filter, null);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }
}

