/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.subscription.payment;

import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.List;
import org.elastos.hive.connection.NodeRPCConnection;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.NetworkException;
import org.elastos.hive.exception.NotFoundException;
import org.elastos.hive.exception.ServerUnknownException;
import org.elastos.hive.exception.UnauthorizedException;
import org.elastos.hive.exception.VaultForbiddenException;
import org.elastos.hive.subscription.payment.CreateOrderParams;
import org.elastos.hive.subscription.payment.Order;
import org.elastos.hive.subscription.payment.OrderCollection;
import org.elastos.hive.subscription.payment.PayOrderParams;
import org.elastos.hive.subscription.payment.PaymentAPI;
import org.elastos.hive.subscription.payment.Receipt;
import org.elastos.hive.subscription.payment.VersionResult;

public class PaymentController {
    private PaymentAPI paymentAPI;

    public PaymentController(NodeRPCConnection connection) {
        this.paymentAPI = connection.createService(PaymentAPI.class, true);
    }

    public Order placeOrder(String subscription, String pricingName) throws HiveException {
        try {
            return (Order)this.paymentAPI.placeOrder(new CreateOrderParams(subscription, pricingName)).execute().body();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public Receipt payOrder(String orderId, String transactionId) throws HiveException {
        try {
            return (Receipt)this.paymentAPI.payOrder(orderId, new PayOrderParams(transactionId)).execute().body();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public Order getOrder(String orderId) throws HiveException {
        List<Order> orders = this.getOrdersInternal("vault", orderId);
        return orders.get(0);
    }

    public List<Order> getOrders(String subscription) throws HiveException {
        return this.getOrdersInternal(subscription, null);
    }

    private List<Order> getOrdersInternal(String subscription, String orderId) throws HiveException {
        try {
            return ((OrderCollection)this.paymentAPI.getOrders(subscription, orderId).execute().body()).getOrders();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public Receipt getReceipt(String orderId) throws HiveException {
        try {
            return (Receipt)this.paymentAPI.getReceipt(orderId).execute().body();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public String getVersion() throws HiveException {
        try {
            return ((VersionResult)this.paymentAPI.getVersion().execute().body()).getVersion();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }
}

