/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.subscription;

import java.io.IOException;
import java.util.List;
import org.elastos.hive.connection.NodeRPCConnection;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.exception.AlreadyExistsException;
import org.elastos.hive.exception.BackupNotFoundException;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.NetworkException;
import org.elastos.hive.exception.PricingPlanNotFoundException;
import org.elastos.hive.exception.ServerUnknownException;
import org.elastos.hive.exception.UnauthorizedException;
import org.elastos.hive.exception.VaultNotFoundException;
import org.elastos.hive.subscription.BackupInfo;
import org.elastos.hive.subscription.PricingPlan;
import org.elastos.hive.subscription.PricingPlanCollection;
import org.elastos.hive.subscription.SubscriptionAPI;
import org.elastos.hive.subscription.VaultInfo;

public class SubscriptionController {
    private final SubscriptionAPI subscriptionAPI;

    public SubscriptionController(NodeRPCConnection connection) {
        this.subscriptionAPI = connection.createService(SubscriptionAPI.class, true);
    }

    public List<PricingPlan> getVaultPricingPlanList() throws HiveException {
        try {
            return ((PricingPlanCollection)this.subscriptionAPI.getPricePlans("vault", "").execute().body()).getPricingPlanCollection();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 404: {
                    throw new PricingPlanNotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public PricingPlan getVaultPricingPlan(String planName) throws HiveException {
        try {
            return ((PricingPlanCollection)this.subscriptionAPI.getPricePlans("vault", planName).execute().body()).getPricingPlanCollection().get(0);
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 404: {
                    throw new PricingPlanNotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e.getMessage());
        }
    }

    public VaultInfo getVaultInfo() throws HiveException {
        try {
            return (VaultInfo)this.subscriptionAPI.getVaultInfo().execute().body();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 404: {
                    throw new VaultNotFoundException((Throwable)e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e.getMessage());
        }
    }

    public VaultInfo subscribeToVault() throws HiveException {
        try {
            return (VaultInfo)this.subscriptionAPI.subscribeToVault().execute().body();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 455: {
                    throw new AlreadyExistsException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public void unsubscribeVault() throws HiveException {
        try {
            this.subscriptionAPI.unsubscribeVault().execute();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException();
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public List<PricingPlan> getBackupPricingPlanList() throws HiveException {
        try {
            return ((PricingPlanCollection)this.subscriptionAPI.getPricePlans("backup", "").execute().body()).getBackupPlans();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 404: {
                    throw new PricingPlanNotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public PricingPlan getBackupPricingPlan(String planName) throws HiveException {
        try {
            return ((PricingPlanCollection)this.subscriptionAPI.getPricePlans("backup", planName).execute().body()).getBackupPlans().get(0);
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 404: {
                    throw new PricingPlanNotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public BackupInfo getBackupInfo() throws HiveException {
        try {
            return (BackupInfo)this.subscriptionAPI.getBackupInfo().execute().body();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 404: {
                    throw new BackupNotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public BackupInfo subscribeToBackup() throws HiveException {
        try {
            return (BackupInfo)this.subscriptionAPI.subscribeToBackup().execute().body();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 455: {
                    throw new AlreadyExistsException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public void unsubscribeBackup() throws HiveException {
        try {
            this.subscriptionAPI.unsubscribeBackup().execute();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException();
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }
}

