/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.elastos.did.jwt.Claims;
import org.elastos.did.jwt.JwtParserBuilder;
import org.elastos.hive.AppContext;
import org.elastos.hive.DataStorage;
import org.elastos.hive.FileStorage;
import org.elastos.hive.connection.NodeRPCConnection;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.connection.auth.AccessToken;
import org.elastos.hive.connection.auth.BridgeHandler;
import org.elastos.hive.endpoint.AboutController;
import org.elastos.hive.endpoint.NodeVersion;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.NotImplementedException;

public class ServiceEndpoint
extends NodeRPCConnection {
    private AppContext context;
    private String providerAddress;
    private String appDid;
    private String appInstanceDid;
    private String serviceInstanceDid;
    private AccessToken accessToken;
    private DataStorage dataStorage;

    protected ServiceEndpoint(AppContext context, String providerAddress) {
        if (context == null || providerAddress == null) {
            throw new IllegalArgumentException("Empty context or provider address parameter");
        }
        this.context = context;
        this.providerAddress = providerAddress;
        String dataDir = context.getAppContextProvider().getLocalDataDir();
        if (!dataDir.endsWith(File.separator)) {
            dataDir = dataDir + File.separator;
        }
        this.dataStorage = new FileStorage(dataDir, context.getUserDid());
        this.accessToken = new AccessToken(this, this.dataStorage, new BridgeHandler(){
            private WeakReference<ServiceEndpoint> weakref;

            @Override
            public void flush(String value) {
                try {
                    ServiceEndpoint endpoint = (ServiceEndpoint)this.weakref.get();
                    Claims claims = (Claims)new JwtParserBuilder().build().parseClaimsJws(value).getBody();
                    endpoint.flushDids(claims.getAudience(), claims.getIssuer());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }

            BridgeHandler setTarget(ServiceEndpoint endpoint) {
                this.weakref = new WeakReference<ServiceEndpoint>(endpoint);
                return this;
            }

            @Override
            public Object target() {
                return this.weakref.get();
            }
        }.setTarget(this));
    }

    public AppContext getAppContext() {
        return this.context;
    }

    @Override
    public String getProviderAddress() {
        return this.providerAddress;
    }

    public String getUserDid() {
        return this.context.getUserDid();
    }

    public String getAppDid() {
        return this.appDid;
    }

    public String getAppInstanceDid() {
        return this.appInstanceDid;
    }

    public String getServiceDid() {
        throw new NotImplementedException();
    }

    public String getServiceInstanceDid() {
        return this.serviceInstanceDid;
    }

    private void flushDids(String appInstanceDId, String serviceInstanceDid) {
        this.appInstanceDid = appInstanceDId;
        this.serviceInstanceDid = serviceInstanceDid;
    }

    public DataStorage getStorage() {
        return this.dataStorage;
    }

    public void refreshAccessToken() throws NodeRPCException {
        this.accessToken.fetch();
    }

    @Override
    protected AccessToken getAccessToken() {
        return this.accessToken;
    }

    public CompletableFuture<NodeVersion> getNodeVersion() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return new AboutController(this).getNodeVersion();
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<String> getLatestCommitId() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return new AboutController(this).getCommitId();
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }
}

