/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.connection.auth;

import org.elastos.hive.AppContextProvider;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.connection.auth.AuthController;
import org.elastos.hive.connection.auth.CodeFetcher;

class RemoteFetcher
implements CodeFetcher {
    private AppContextProvider contextProvider;
    private AuthController controller;

    public RemoteFetcher(ServiceEndpoint serviceEndpoint) {
        this.contextProvider = serviceEndpoint.getAppContext().getAppContextProvider();
        this.controller = new AuthController(serviceEndpoint, this.contextProvider.getAppInstanceDocument());
    }

    @Override
    public String fetch() throws NodeRPCException {
        try {
            String challenge = this.controller.signIn(this.contextProvider.getAppInstanceDocument());
            String challengeResponse = this.contextProvider.getAuthorization(challenge).get();
            return this.controller.auth(challengeResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NodeRPCException(401, -1, "Failed to get token by auth requests.");
        }
    }

    @Override
    public void invalidate() {
    }
}

