/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.connection.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.HashMap;
import org.elastos.did.DIDDocument;
import org.elastos.did.jwt.Claims;
import org.elastos.did.jwt.JwtParserBuilder;
import org.elastos.hive.connection.NodeRPCConnection;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.connection.auth.AccessCode;
import org.elastos.hive.connection.auth.AuthAPI;
import org.elastos.hive.connection.auth.ChallengeRequest;
import org.elastos.hive.connection.auth.ChallengeResponse;
import org.elastos.hive.connection.auth.SignInRequest;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.NetworkException;
import org.elastos.hive.exception.ServerUnknownException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthController {
    private static final Logger log = LoggerFactory.getLogger(AuthController.class);
    private AuthAPI authAPI;
    private String expectationAudience;

    public AuthController(NodeRPCConnection connection, DIDDocument appInstanceDidDoc) {
        this.authAPI = connection.createService(AuthAPI.class, false);
        this.expectationAudience = appInstanceDidDoc.getSubject().toString();
    }

    public String signIn(DIDDocument appInstanceDidDoc) throws HiveException {
        try {
            Object document = new ObjectMapper().readValue(appInstanceDidDoc.toString(), HashMap.class);
            ChallengeRequest challenge = (ChallengeRequest)this.authAPI.signIn(new SignInRequest(document)).execute().body();
            if (!this.checkValid(challenge.getChallenge(), this.expectationAudience)) {
                log.error("Failed to check the valid of challenge code when sign in.");
                throw new ServerUnknownException("Invalid challenge code, possibly being hacked.");
            }
            return challenge.getChallenge();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public String auth(String challengeResponse) throws HiveException {
        try {
            AccessCode token = (AccessCode)this.authAPI.auth(new ChallengeResponse(challengeResponse)).execute().body();
            if (!this.checkValid(token.getToken(), this.expectationAudience)) {
                log.error("Failed to check the valid of access token when auth.");
                throw new ServerUnknownException("Invalid challenge code, possibly being hacked.");
            }
            return token.getToken();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 400: {
                    throw new InvalidParameterException(e.getMessage());
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    private boolean checkValid(String jwtCode, String expectationDid) {
        try {
            Claims claims = (Claims)new JwtParserBuilder().build().parseClaimsJws(jwtCode).getBody();
            return claims.getExpiration().getTime() > System.currentTimeMillis() && claims.getAudience().equals(expectationDid);
        }
        catch (Exception e) {
            return false;
        }
    }
}

