/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.elastos.hive.AppContext;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.NotImplementedException;
import org.elastos.hive.service.PaymentService;
import org.elastos.hive.service.SubscriptionService;
import org.elastos.hive.subscription.PricingPlan;
import org.elastos.hive.subscription.SubscriptionController;
import org.elastos.hive.subscription.VaultInfo;
import org.elastos.hive.subscription.payment.Order;
import org.elastos.hive.subscription.payment.PaymentController;
import org.elastos.hive.subscription.payment.Receipt;

public class VaultSubscription
extends ServiceEndpoint
implements SubscriptionService<VaultInfo>,
PaymentService {
    private SubscriptionController subscriptionController = new SubscriptionController(this);
    private PaymentController paymentController = new PaymentController(this);

    public VaultSubscription(AppContext context, String providerAddress) throws HiveException {
        super(context, providerAddress);
    }

    @Override
    public CompletableFuture<List<PricingPlan>> getPricingPlanList() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.subscriptionController.getVaultPricingPlanList();
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<PricingPlan> getPricingPlan(String planName) {
        return CompletableFuture.supplyAsync(() -> {
            if (planName == null) {
                throw new IllegalArgumentException("Empty plan name");
            }
            try {
                return this.subscriptionController.getVaultPricingPlan(planName);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<VaultInfo> subscribe() {
        return this.subscribe(null);
    }

    @Override
    public CompletableFuture<VaultInfo> subscribe(String credential) {
        return CompletableFuture.supplyAsync(() -> {
            if (credential != null) {
                throw new NotImplementedException("Paid pricing plan will be supported later");
            }
            try {
                return this.subscriptionController.subscribeToVault(credential);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> unsubscribe() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.subscriptionController.unsubscribeVault();
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<VaultInfo> checkSubscription() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.subscriptionController.getVaultInfo();
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Order> placeOrder(String planName) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.paymentController.placeOrder("vault", planName);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Order> getOrder(String orderId) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.paymentController.getOrder(orderId);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Receipt> payOrder(String orderId, String transactionId) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.paymentController.payOrder(orderId, transactionId);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<List<Order>> getOrderList() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.paymentController.getOrders("vault");
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Receipt> getReceipt(String orderId) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.paymentController.getReceipt(orderId);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public CompletableFuture<String> getVersion() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.paymentController.getVersion();
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }
}

