/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault.backup.credential;

import java.util.concurrent.ExecutionException;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.connection.auth.CodeFetcher;
import org.elastos.hive.service.BackupContext;

class RemoteResolver
implements CodeFetcher {
    private ServiceEndpoint serviceEndpoint;
    private BackupContext backupContext;
    private String targetDid;
    private String targetHost;

    public RemoteResolver(ServiceEndpoint serviceEndpoint, BackupContext backupContext, String targetServiceDid, String targetAddress) {
        this.serviceEndpoint = serviceEndpoint;
        this.backupContext = backupContext;
        this.targetDid = targetServiceDid;
        this.targetHost = targetAddress;
    }

    @Override
    public String fetch() throws NodeRPCException {
        if (this.serviceEndpoint.getServiceInstanceDid() == null) {
            this.serviceEndpoint.refreshAccessToken();
        }
        try {
            return this.backupContext.getAuthorization(this.serviceEndpoint.getServiceInstanceDid(), this.targetDid, this.targetHost).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new NodeRPCException(401, -1, "Failed to create backup credential." + e.getCause().getMessage());
        }
    }

    @Override
    public void invalidate() {
    }
}

