/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault.backup;

import java.io.IOException;
import java.security.InvalidParameterException;
import org.elastos.hive.connection.NodeRPCConnection;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.exception.BackupIsInProcessingException;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.InsufficientStorageException;
import org.elastos.hive.exception.NetworkException;
import org.elastos.hive.exception.NotFoundException;
import org.elastos.hive.exception.ServerUnknownException;
import org.elastos.hive.exception.UnauthorizedException;
import org.elastos.hive.exception.VaultForbiddenException;
import org.elastos.hive.service.BackupService;
import org.elastos.hive.vault.backup.BackupAPI;
import org.elastos.hive.vault.backup.BackupResult;
import org.elastos.hive.vault.backup.RequestParams;

public class BackupController {
    private BackupAPI backupAPI;

    public BackupController(NodeRPCConnection connection) {
        this.backupAPI = connection.createService(BackupAPI.class, true);
    }

    public void startBackup(String credential) throws HiveException {
        try {
            this.backupAPI.saveToNode(new RequestParams(credential)).execute().body();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    if (e.getInternalCode() == 2) {
                        throw new BackupIsInProcessingException((Throwable)e);
                    }
                    throw new InvalidParameterException(e.getMessage());
                }
                case 507: {
                    throw new InsufficientStorageException((Throwable)e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public void restoreFrom(String credential) throws HiveException {
        try {
            this.backupAPI.restoreFromNode(new RequestParams(credential)).execute().body();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 400: {
                    if (e.getInternalCode() == 2) {
                        throw new BackupIsInProcessingException((Throwable)e);
                    }
                    throw new InvalidParameterException(e.getMessage());
                }
                case 507: {
                    throw new InsufficientStorageException((Throwable)e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public BackupService.BackupResult checkResult() throws HiveException {
        try {
            return ((BackupResult)this.backupAPI.getState().execute().body()).getStatusResult();
        }
        catch (NodeRPCException e) {
            switch (e.getCode()) {
                case 401: {
                    throw new UnauthorizedException(e);
                }
                case 403: {
                    throw new VaultForbiddenException((Throwable)e);
                }
                case 404: {
                    throw new NotFoundException(e);
                }
            }
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }
}

