/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.subscription.payment;

import java.io.IOException;
import java.util.List;
import org.elastos.hive.connection.NodeRPCConnection;
import org.elastos.hive.connection.NodeRPCException;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.NetworkException;
import org.elastos.hive.exception.NotImplementedException;
import org.elastos.hive.exception.ServerUnknownException;
import org.elastos.hive.subscription.payment.CreateOrderParams;
import org.elastos.hive.subscription.payment.Order;
import org.elastos.hive.subscription.payment.PayOrderParams;
import org.elastos.hive.subscription.payment.PaymentAPI;
import org.elastos.hive.subscription.payment.Receipt;

public class PaymentController {
    private PaymentAPI paymentAPI;

    public PaymentController(NodeRPCConnection connection) {
        this.paymentAPI = connection.createService(PaymentAPI.class, true);
    }

    public Order createOrder(String subscription, String pricingPlan) throws HiveException {
        try {
            return (Order)this.paymentAPI.createOrder(new CreateOrderParams()).execute().body();
        }
        catch (NodeRPCException e) {
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public Receipt payOrder(String orderId, String transIds) throws HiveException {
        try {
            return (Receipt)this.paymentAPI.payOrder(new PayOrderParams()).execute().body();
        }
        catch (NodeRPCException e) {
            throw new ServerUnknownException(e);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public Order getOrderInfo(String orderId) throws HiveException {
        throw new NotImplementedException();
    }

    public List<Order> getOrders(String subscription) throws HiveException {
        throw new NotImplementedException();
    }

    public List<Receipt> getReceipts(String subscription) throws HiveException {
        throw new NotImplementedException();
    }

    public String getVersion() throws HiveException {
        throw new NotImplementedException();
    }
}

