/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.elastos.did.DID;
import org.elastos.did.DIDAdapter;
import org.elastos.did.DIDBackend;
import org.elastos.did.DIDDocument;
import org.elastos.did.DefaultDIDAdapter;
import org.elastos.did.exception.DIDResolveException;
import org.elastos.did.exception.MalformedDIDException;
import org.elastos.hive.AppContextProvider;
import org.elastos.hive.exception.BadContextProviderException;
import org.elastos.hive.exception.DIDNotPublishedException;
import org.elastos.hive.exception.DIDResolverNotSetupException;
import org.elastos.hive.exception.DIDResoverAlreadySetupException;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.NetworkException;
import org.elastos.hive.exception.ProviderNotSetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppContext {
    private static final Logger log = LoggerFactory.getLogger(AppContext.class);
    private static boolean resolverHasSetup = false;
    private AppContextProvider contextProvider;
    private String userDid;

    private AppContext(AppContextProvider provider, String userDid) {
        this.userDid = userDid;
        this.contextProvider = provider;
    }

    public AppContextProvider getAppContextProvider() {
        return this.contextProvider;
    }

    public String getUserDid() {
        return this.userDid;
    }

    public static void setupResolver(String resolver, String cacheDir) throws HiveException {
        if (cacheDir == null || resolver == null) {
            throw new IllegalArgumentException("Invalid parameters to setup DID resolver");
        }
        if (resolverHasSetup) {
            throw new DIDResoverAlreadySetupException();
        }
        DIDBackend.initialize((DIDAdapter)new DefaultDIDAdapter(resolver));
        resolverHasSetup = true;
    }

    public static AppContext build(AppContextProvider provider, String userDid) {
        if (provider == null) {
            throw new IllegalArgumentException("Missing AppContext provider");
        }
        if (provider.getLocalDataDir() == null) {
            throw new BadContextProviderException("Missing method to acquire data location");
        }
        if (provider.getAppInstanceDocument() == null) {
            throw new BadContextProviderException("Missing method to acquire App instance DID document");
        }
        if (!resolverHasSetup) {
            throw new DIDResolverNotSetupException();
        }
        return new AppContext(provider, userDid);
    }

    public static CompletableFuture<String> getProviderAddress(String targetDid) {
        return AppContext.getProviderAddress(targetDid, null);
    }

    public static CompletableFuture<String> getProviderAddress(String targetDid, String preferredProviderAddress) {
        return CompletableFuture.supplyAsync(() -> {
            if (targetDid == null) {
                throw new IllegalArgumentException("Missing input parameter for target Did");
            }
            if (preferredProviderAddress != null) {
                return preferredProviderAddress;
            }
            try {
                List services = null;
                DID did = new DID(targetDid);
                DIDDocument doc = did.resolve();
                if (doc == null) {
                    throw new DIDNotPublishedException(String.format("The DID %s has not published onto sideChain", targetDid));
                }
                services = doc.selectServices((String)null, "HiveVault");
                if (services == null || services.size() == 0) {
                    throw new ProviderNotSetException(String.format("No 'HiveVault' services declared on DID document %s", targetDid));
                }
                return ((DIDDocument.Service)services.get(0)).getServiceEndpoint();
            }
            catch (MalformedDIDException e) {
                log.error("Malformed target did {} with error: {}", (Object)targetDid, (Object)e.getMessage());
                throw new IllegalArgumentException("Malformed did string: " + targetDid);
            }
            catch (DIDResolveException e) {
                log.error("Resolving the target DID {} failed: {}", (Object)targetDid, (Object)e.getMessage());
                throw new CompletionException(new NetworkException("Resolving DID failed: " + e.getMessage()));
            }
        });
    }
}

