/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.elastos.hive.AppContext;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.service.ScriptingInvocationService;
import org.elastos.hive.vault.scripting.ScriptingController;

public class ScriptRunner
extends ServiceEndpoint
implements ScriptingInvocationService {
    private ScriptingController controller = new ScriptingController(this);

    public ScriptRunner(AppContext context, String providerAddress) {
        super(context, providerAddress);
    }

    @Override
    public <T> CompletableFuture<T> callScript(String name, JsonNode params, String targetDid, String targetAppDid, Class<T> resultType) {
        return CompletableFuture.supplyAsync(() -> {
            if (name == null) {
                throw new IllegalArgumentException("Missing script name.");
            }
            if (targetDid == null) {
                throw new IllegalArgumentException("Missing target user DID");
            }
            if (targetAppDid == null) {
                throw new IllegalArgumentException("Missing target application DID");
            }
            if (resultType == null) {
                throw new IllegalArgumentException("Missing result type");
            }
            try {
                return this.controller.callScript(name, params, targetDid, targetAppDid, resultType);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    public <T> CompletableFuture<T> callScriptUrl(String name, String params, String targetDid, String targetAppDid, Class<T> resultType) {
        return CompletableFuture.supplyAsync(() -> {
            if (name == null) {
                throw new IllegalArgumentException("Missing script name.");
            }
            if (params == null) {
                throw new IllegalArgumentException("Missing parameters to run the script");
            }
            if (targetDid == null) {
                throw new IllegalArgumentException("Missing target user DID");
            }
            if (targetAppDid == null) {
                throw new IllegalArgumentException("Missing target application DID");
            }
            if (resultType == null) {
                throw new IllegalArgumentException("Missing result type");
            }
            try {
                return this.controller.callScriptUrl(name, params, targetDid, targetAppDid, resultType);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public <T> CompletableFuture<T> downloadFile(String transactionId, Class<T> resultType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (transactionId == null) {
                    throw new IllegalArgumentException("Missing transactionId.");
                }
                if (resultType == null) {
                    throw new IllegalArgumentException("Missing result type");
                }
                return this.controller.downloadFile(transactionId, resultType);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public <T> CompletableFuture<T> uploadFile(String transactionId, Class<T> resultType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (transactionId == null) {
                    throw new IllegalArgumentException("Missing transactionId.");
                }
                if (resultType == null) {
                    throw new IllegalArgumentException("Missing result type");
                }
                return this.controller.uploadFile(transactionId, resultType);
            }
            catch (RuntimeException | HiveException e) {
                throw new CompletionException(e);
            }
        });
    }
}

