/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault;

import java.io.IOException;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.exception.VaultAlreadyExistException;
import org.elastos.hive.network.response.HiveResponseBody;
import org.elastos.hive.network.response.VaultCreateResponseBody;
import org.elastos.hive.network.response.VaultInfoResponseBody;
import org.elastos.hive.vault.HiveVaultRender;

public class SubscriptionServiceRender
extends HiveVaultRender {
    public SubscriptionServiceRender(ServiceEndpoint serviceEndpoint) {
        super(serviceEndpoint);
    }

    public void subscribe() throws IOException {
        VaultCreateResponseBody body = (VaultCreateResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getSubscriptionApi().createVault().execute().body());
        if (Boolean.TRUE.equals(body.getExisting())) {
            throw new VaultAlreadyExistException("The vault already exists");
        }
    }

    public void subscribeBackup() throws IOException {
        VaultCreateResponseBody body = (VaultCreateResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getSubscriptionApi().createBackupVault().execute().body());
        if (Boolean.TRUE.equals(body.getExisting())) {
            throw new VaultAlreadyExistException("The backup vault already exists");
        }
    }

    public void unsubscribe() throws IOException {
        HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getSubscriptionApi().removeVault().execute().body());
    }

    public void activate() throws IOException {
        HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getSubscriptionApi().unfreeze().execute().body());
    }

    public void deactivate() throws IOException {
        HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getSubscriptionApi().freeze().execute().body());
    }

    public VaultInfoResponseBody getVaultInfo() throws IOException {
        return (VaultInfoResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getSubscriptionApi().getVaultInfo().execute().body());
    }

    public VaultInfoResponseBody getBackupVaultInfo() throws IOException {
        return (VaultInfoResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getSubscriptionApi().getBackupVaultInfo().execute().body());
    }
}

