/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.elastos.hive.ScriptRunner;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.network.model.Condition;
import org.elastos.hive.network.model.Executable;
import org.elastos.hive.network.request.RegisterScriptRequestBody;
import org.elastos.hive.network.response.HiveResponseBody;
import org.elastos.hive.service.ScriptingService;
import org.elastos.hive.vault.HiveVaultRender;
import org.elastos.hive.vault.HttpExceptionHandler;

class ScriptingServiceRender
extends HiveVaultRender
implements ScriptingService,
HttpExceptionHandler {
    private ScriptRunner scriptRunner = new ScriptRunner(this.getServiceEndpoint().getAppContext(), this.getServiceEndpoint().getProviderAddress(), this.getServiceEndpoint().getTargetDid(), this.getServiceEndpoint().getAppDid());

    public ScriptingServiceRender(ServiceEndpoint serviceEndpoint) {
        super(serviceEndpoint);
    }

    @Override
    public CompletableFuture<Boolean> registerScript(String name, Executable executable, boolean allowAnonymousUser, boolean allowAnonymousApp) {
        return this.registerScript(name, null, executable, allowAnonymousUser, allowAnonymousApp);
    }

    @Override
    public CompletableFuture<Boolean> registerScript(String name, Condition condition, Executable executable, boolean allowAnonymousUser, boolean allowAnonymousApp) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getScriptingApi().registerScript(new RegisterScriptRequestBody().setName(name).setExecutable(executable).setAllowAnonymousUser(allowAnonymousUser).setAllowAnonymousApp(allowAnonymousApp).setCondition(condition)).execute().body());
                return true;
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public <T> CompletableFuture<T> callScript(String name, JsonNode params, String appDid, Class<T> resultType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.scriptRunner.callScript(name, params, appDid, resultType);
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public <T> CompletableFuture<T> callScriptUrl(String name, String params, String appDid, Class<T> resultType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.scriptRunner.callScriptUrl(name, params, appDid, resultType);
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public <T> CompletableFuture<T> uploadFile(String transactionId, Class<T> resultType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.scriptRunner.uploadFile(transactionId, resultType);
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public <T> CompletableFuture<T> downloadFile(String transactionId, Class<T> resultType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.scriptRunner.downloadFile(transactionId, resultType);
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }
}

