/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault;

import java.io.IOException;
import java.util.List;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.network.request.PayOrderRequestBody;
import org.elastos.hive.network.request.PaymentCreateRequestBody;
import org.elastos.hive.network.response.HiveResponseBody;
import org.elastos.hive.network.response.OrderInfoResponseBody;
import org.elastos.hive.network.response.PaymentCreateResponseBody;
import org.elastos.hive.network.response.PaymentPackageResponseBody;
import org.elastos.hive.network.response.PaymentPlanResponseBody;
import org.elastos.hive.payment.Order;
import org.elastos.hive.payment.PricingPlan;
import org.elastos.hive.vault.HiveVaultRender;

public class PaymentServiceRender
extends HiveVaultRender {
    public PaymentServiceRender(ServiceEndpoint serviceEndpoint) {
        super(serviceEndpoint);
    }

    public List<PricingPlan> getPricingPlanList() throws IOException {
        return ((PaymentPackageResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getPaymentApi().getPackageInfo().execute().body())).getPricingPlans();
    }

    public List<PricingPlan> getBackupPlanList() throws IOException {
        return ((PaymentPackageResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getPaymentApi().getPackageInfo().execute().body())).getBackupPlans();
    }

    public PricingPlan getPricingPlan(String planName) throws IOException {
        return this.getPricePlanByResponseBody((PaymentPlanResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getPaymentApi().getPricingPlan(planName).execute().body()));
    }

    public PricingPlan getBackupPlan(String planName) throws IOException {
        return this.getPricePlanByResponseBody((PaymentPlanResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getPaymentApi().getBackupPlan(planName).execute().body()));
    }

    private PricingPlan getPricePlanByResponseBody(PaymentPlanResponseBody respBody) {
        return new PricingPlan().setAmount(respBody.getAmount()).setCurrency(respBody.getCurrency()).setServiceDays(respBody.getServiceDays()).setMaxStorage(respBody.getMaxStorage()).setName(respBody.getName());
    }

    public String createPricingOrder(String planName) throws IOException {
        return this.createOrder(planName, null);
    }

    public String createBackupOrder(String planName) throws IOException {
        return this.createOrder(null, planName);
    }

    private String createOrder(String pricingPlanName, String backupPlanName) throws IOException {
        return ((PaymentCreateResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getPaymentApi().createOrder(new PaymentCreateRequestBody(pricingPlanName, backupPlanName)).execute().body())).getOrderId();
    }

    public void payOrder(String orderId, List<String> transIds) throws IOException {
        HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getPaymentApi().payOrder(new PayOrderRequestBody().setOrderId(orderId).setPayTxids(transIds)).execute().body());
    }

    public Order getOrderInfo(String orderId) throws IOException {
        return ((OrderInfoResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getPaymentApi().getOrderInfo(orderId).execute().body())).getOrderInfo();
    }
}

