/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import okhttp3.ResponseBody;
import org.elastos.hive.Vault;
import org.elastos.hive.exception.FileDoesNotExistsException;
import org.elastos.hive.exception.HttpFailedException;
import org.elastos.hive.network.model.FileInfo;
import org.elastos.hive.network.request.FilesCopyRequestBody;
import org.elastos.hive.network.request.FilesDeleteRequestBody;
import org.elastos.hive.network.request.FilesMoveRequestBody;
import org.elastos.hive.network.response.FilesHashResponseBody;
import org.elastos.hive.network.response.FilesListResponseBody;
import org.elastos.hive.network.response.FilesPropertiesResponseBody;
import org.elastos.hive.network.response.HiveResponseBody;
import org.elastos.hive.service.FilesService;
import org.elastos.hive.vault.HiveVaultRender;
import org.elastos.hive.vault.HttpExceptionHandler;
import retrofit2.Response;

class FilesServiceRender
extends HiveVaultRender
implements FilesService,
HttpExceptionHandler {
    public FilesServiceRender(Vault vault) {
        super(vault);
    }

    @Override
    public <T> CompletableFuture<T> upload(String path, Class<T> resultType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return HiveResponseBody.getRequestStream(this.getConnectionManager().openConnection("/files/upload/" + path), resultType);
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public CompletableFuture<List<FileInfo>> list(String path) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return ((FilesListResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getFilesApi().list(path).execute().body())).getFileInfoList();
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public CompletableFuture<FileInfo> stat(String path) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return ((FilesPropertiesResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getFilesApi().properties(path).execute().body())).getFileInfo();
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public <T> CompletableFuture<T> download(String path, Class<T> resultType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return HiveResponseBody.getResponseStream((Response<ResponseBody>)this.getConnectionManager().getFilesApi().download(path).execute(), resultType);
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> delete(String path) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getFilesApi().delete(new FilesDeleteRequestBody(path)).execute().body());
                return true;
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> move(String source, String target) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getFilesApi().move(new FilesMoveRequestBody(source, target)).execute().body());
                return true;
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> copy(String source, String target) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getFilesApi().copy(new FilesCopyRequestBody(source, target)).execute().body());
                return true;
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public CompletableFuture<String> hash(String path) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return ((FilesHashResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getFilesApi().hash(path).execute().body())).getSha256();
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public Exception convertException(Exception e) {
        HttpFailedException ex;
        if (e instanceof HttpFailedException && (ex = (HttpFailedException)e).getCode() == 404) {
            return new FileDoesNotExistsException();
        }
        return HttpExceptionHandler.super.convertException(e);
    }
}

