/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.auth.BackupRemoteResolver;
import org.elastos.hive.auth.LocalResolver;
import org.elastos.hive.auth.TokenResolver;
import org.elastos.hive.network.request.BackupRestoreRequestBody;
import org.elastos.hive.network.request.BackupSaveRequestBody;
import org.elastos.hive.network.response.BackupStateResponseBody;
import org.elastos.hive.network.response.HiveResponseBody;
import org.elastos.hive.service.BackupContext;
import org.elastos.hive.service.BackupService;
import org.elastos.hive.vault.HiveVaultRender;
import org.elastos.hive.vault.HttpExceptionHandler;

class BackupServiceRender
extends HiveVaultRender
implements BackupService,
HttpExceptionHandler {
    private BackupContext backupContext;
    private TokenResolver tokenResolver;

    public BackupServiceRender(ServiceEndpoint serviceEndpoint) {
        super(serviceEndpoint);
    }

    @Override
    public CompletableFuture<Void> setupContext(BackupContext backupContext) {
        this.backupContext = backupContext;
        this.tokenResolver = new LocalResolver(this.getServiceEndpoint().getUserDid(), this.getServiceEndpoint().getProviderAddress(), "backup_credential", this.getServiceEndpoint().getAppContext().getAppContextProvider().getLocalDataDir());
        this.tokenResolver.setNextResolver(new BackupRemoteResolver(this.getServiceEndpoint(), backupContext, backupContext.getParameter("targetServiceDid"), backupContext.getParameter("targetAddress")));
        return null;
    }

    @Override
    public CompletableFuture<Void> startBackup() {
        return CompletableFuture.runAsync(() -> {
            try {
                HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getBackupApi().saveToNode(new BackupSaveRequestBody(this.tokenResolver.getToken().getAccessToken())).execute().body());
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public CompletableFuture<Void> stopBackup() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Void> restoreFrom() {
        return CompletableFuture.runAsync(() -> {
            try {
                HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getBackupApi().restoreFromNode(new BackupRestoreRequestBody(this.tokenResolver.getToken().getAccessToken())).execute().body());
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public CompletableFuture<Void> stopRestore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<BackupService.BackupResult> checkResult() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return ((BackupStateResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getBackupApi().getState().execute().body())).getStatusResult();
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }
}

