/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.vault;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import org.elastos.hive.AppContextProvider;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.auth.AuthToken;
import org.elastos.hive.network.request.AuthRequestBody;
import org.elastos.hive.network.request.SignInRequestBody;
import org.elastos.hive.network.response.AuthResponseBody;
import org.elastos.hive.network.response.HiveResponseBody;
import org.elastos.hive.network.response.SignInResponseBody;
import org.elastos.hive.utils.JwtUtil;
import org.elastos.hive.vault.HiveVaultRender;
import org.elastos.hive.vault.HttpExceptionHandler;

public class AuthenticationServiceRender
extends HiveVaultRender
implements HttpExceptionHandler {
    private AppContextProvider contextProvider;

    public AuthenticationServiceRender(ServiceEndpoint serviceEndpoint) {
        super(serviceEndpoint);
        this.contextProvider = serviceEndpoint.getAppContext().getAppContextProvider();
    }

    public String signIn4Token() throws IOException, ExecutionException, InterruptedException {
        SignInResponseBody rspBody = (SignInResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getAuthApi().signIn(new SignInRequestBody(new ObjectMapper().readValue(this.contextProvider.getAppInstanceDocument().toString(), HashMap.class))).execute().body());
        rspBody.checkValid(this.contextProvider.getAppInstanceDocument().getSubject().toString());
        return this.contextProvider.getAuthorization(rspBody.getChallenge()).get();
    }

    public String signIn4Issuer() throws IOException {
        SignInResponseBody rspBody = (SignInResponseBody)this.getConnectionManager().getAuthApi().signIn(new SignInRequestBody(new ObjectMapper().readValue(this.contextProvider.getAppInstanceDocument().toString(), HashMap.class))).execute().body();
        return HiveResponseBody.validateBody(rspBody).checkValid(this.contextProvider.getAppInstanceDocument().getSubject().toString()).getIssuer();
    }

    public AuthToken auth(String token) throws IOException {
        AuthResponseBody rspBody = (AuthResponseBody)HiveResponseBody.validateBody((HiveResponseBody)this.getConnectionManager().getAuthApi().auth(new AuthRequestBody(token)).execute().body());
        long exp = JwtUtil.getBody(rspBody.getToken()).getExpiration().getTime();
        long expiresTime = System.currentTimeMillis() / 1000L + exp / 1000L;
        return new AuthToken(rspBody.getToken(), expiresTime, "token");
    }
}

