/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.network.response;

import com.google.gson.annotations.SerializedName;
import org.elastos.did.jwt.Claims;
import org.elastos.hive.exception.HiveSdkException;
import org.elastos.hive.network.response.HiveResponseBody;
import org.elastos.hive.utils.JwtUtil;

public class SignInResponseBody
extends HiveResponseBody {
    @SerializedName(value="challenge")
    private String challenge;

    public String getChallenge() {
        return this.challenge;
    }

    public Claims checkValid(String validAudience) {
        Claims claims = JwtUtil.getBody(this.challenge);
        if (claims.getExpiration().getTime() <= System.currentTimeMillis()) {
            throw new HiveSdkException("Bad jwt expiration date");
        }
        if (!claims.getAudience().equals(validAudience)) {
            throw new HiveSdkException("Bad jwt audience value");
        }
        return claims;
    }
}

