/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.network.response;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.sasl.AuthenticationException;
import okhttp3.ResponseBody;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.HiveSdkException;
import org.elastos.hive.exception.HttpFailedException;
import org.elastos.hive.exception.InvalidParameterException;
import org.elastos.hive.exception.NoEnoughSpaceException;
import org.elastos.hive.exception.VaultLockedException;
import org.elastos.hive.network.model.KeyValueDict;
import org.elastos.hive.network.model.UploadOutputStream;
import org.elastos.hive.network.model.UploadOutputStreamWriter;
import retrofit2.Response;

public class HiveResponseBody {
    private static final String SUCCESS = "OK";
    private static final SimpleDateFormat FORMAT_DT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Map<Integer, String> errorMessages;
    @SerializedName(value="_status")
    private String status;
    @SerializedName(value="_error")
    private Error error;

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public int getErrorCode() {
        return this.error == null ? -1 : this.error.code;
    }

    public String getErrorMessage() {
        return this.error == null ? "" : this.error.message;
    }

    public boolean failed() {
        return !SUCCESS.equals(this.status);
    }

    public static <T extends HiveResponseBody> T validateBody(Response<T> response) throws IOException {
        return (T)HiveResponseBody.validateBody((HiveResponseBody)response.body());
    }

    public static <T extends HiveResponseBody> T validateBody(T body) throws IOException {
        if (body == null) {
            throw new HiveSdkException("Failed to get response body(null)");
        }
        if (body.failed()) {
            throw new HttpFailedException(600, HiveResponseBody.getHttpErrorMessages().get(600));
        }
        return body;
    }

    public static String validateBodyStr(Response<ResponseBody> response) {
        ResponseBody body = (ResponseBody)response.body();
        if (body == null) {
            throw new HiveSdkException("Failed to get body on validateBody");
        }
        try {
            String bodyStr = body.string();
            if (((HiveResponseBody)new Gson().fromJson(bodyStr, HiveResponseBody.class)).failed()) {
                throw new HiveSdkException("Get ERR response status on validateBody");
            }
            return bodyStr;
        }
        catch (IOException e) {
            throw new HiveSdkException(e.getMessage());
        }
    }

    public static <T> T getValue(String json, Class<T> clz) {
        Object obj = null;
        try {
            obj = clz.isAssignableFrom(String.class) ? json : (clz.isAssignableFrom(byte[].class) ? (Object)json.getBytes() : (clz.isAssignableFrom(JsonNode.class) ? new ObjectMapper().readTree(json) : (clz.isAssignableFrom(Reader.class) ? new StringReader(json) : new ObjectMapper().readValue(json, clz))));
        }
        catch (Exception e) {
            throw new HiveSdkException("unsupported result type for call script.");
        }
        return (T)obj;
    }

    public static <T> T getRequestStream(HttpURLConnection connection, Class<T> resultType) throws IOException {
        OutputStream outputStream = connection.getOutputStream();
        if (resultType.isAssignableFrom(OutputStream.class)) {
            UploadOutputStream uploader = new UploadOutputStream(connection, outputStream);
            return resultType.cast(uploader);
        }
        if (resultType.isAssignableFrom(OutputStreamWriter.class)) {
            UploadOutputStreamWriter writer = new UploadOutputStreamWriter(connection, outputStream);
            return resultType.cast(writer);
        }
        throw new InvalidPropertiesFormatException("Not supported result type: " + resultType.getName());
    }

    public static <T> T getResponseStream(Response<ResponseBody> response, Class<T> resultType) {
        ResponseBody body = (ResponseBody)response.body();
        if (body == null) {
            throw new HiveSdkException("Failed to get response body");
        }
        if (resultType.isAssignableFrom(Reader.class)) {
            return resultType.cast(new InputStreamReader(body.byteStream()));
        }
        if (resultType.isAssignableFrom(InputStream.class)) {
            return resultType.cast(body.byteStream());
        }
        throw new InvalidParameterException("Not supported result type");
    }

    public static Map<String, Object> jsonNode2Map(JsonNode node) {
        return (Map)new ObjectMapper().convertValue((Object)node, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static JsonNode map2JsonNode(Map<String, Object> map) {
        return (JsonNode)new ObjectMapper().convertValue(map, JsonNode.class);
    }

    public static KeyValueDict jsonNode2KeyValueDic(JsonNode node) {
        return (KeyValueDict)new ObjectMapper().convertValue((Object)node, (TypeReference)new TypeReference<KeyValueDict>(){});
    }

    public static List<KeyValueDict> jsonNodeList2KeyValueDicList(List<JsonNode> docs) {
        return docs.stream().map(HiveResponseBody::jsonNode2KeyValueDic).collect(Collectors.toList());
    }

    public static JsonNode KeyValueDict2JsonNode(KeyValueDict dict) {
        return (JsonNode)new ObjectMapper().convertValue((Object)dict, JsonNode.class);
    }

    public static List<JsonNode> KeyValueDictList2JsonNodeList(List<KeyValueDict> dicts) {
        return dicts.stream().map(HiveResponseBody::KeyValueDict2JsonNode).collect(Collectors.toList());
    }

    public static Map<Integer, String> getHttpErrorMessages() {
        if (errorMessages == null) {
            HashMap<Integer, String> messages = new HashMap<Integer, String>();
            messages.put(400, "bad request");
            messages.put(401, "auth failed");
            messages.put(402, "payment required");
            messages.put(403, "forbidden");
            messages.put(404, "not found");
            messages.put(405, "method not allowed");
            messages.put(406, "not acceptable");
            messages.put(423, "locked");
            messages.put(452, "checksum failed or not enough space");
            messages.put(500, "internal server error");
            messages.put(501, "not implemented");
            messages.put(503, "service unavailable");
            messages.put(507, "insufficient storage");
            messages.put(600, "error body status");
            errorMessages = messages;
        }
        return errorMessages;
    }

    public static Exception convertException(Exception e) {
        if (e instanceof HttpFailedException) {
            HttpFailedException ex = (HttpFailedException)e;
            return HiveResponseBody.getHttpExceptionByCode(ex.getCode(), ex.getMessage());
        }
        if (e instanceof IOException) {
            return new HiveException(e.getMessage());
        }
        return e;
    }

    public static IOException getHttpExceptionByCode(int code, String message) {
        switch (code) {
            case 401: {
                return new AuthenticationException();
            }
            case 423: {
                return new VaultLockedException();
            }
            case 452: {
                return new NoEnoughSpaceException();
            }
        }
        return new HttpFailedException(code, message);
    }

    protected String getDateStrByStamp(long value) {
        return FORMAT_DT.format(new Date(value));
    }

    static class Error {
        @SerializedName(value="code")
        int code;
        @SerializedName(value="message")
        String message;

        Error() {
        }
    }
}

