/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.connection;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.elastos.hive.auth.AuthToken;
import org.elastos.hive.auth.LocalResolver;
import org.elastos.hive.auth.RemoteResolver;
import org.elastos.hive.auth.TokenResolver;
import org.elastos.hive.connection.ConnectionManager;
import org.elastos.hive.exception.HttpFailedException;
import org.elastos.hive.network.response.HiveResponseBody;

public class RequestInterceptor
implements Interceptor {
    private final boolean needToken;
    private TokenResolver tokenResolver;

    RequestInterceptor(ConnectionManager connectionManager, boolean needToken) {
        this.tokenResolver = new LocalResolver(connectionManager.getServiceEndpoint().getAppContext().getUserDid(), connectionManager.getServiceEndpoint().getProviderAddress(), "auth_token", connectionManager.getServiceEndpoint().getAppContext().getAppContextProvider().getLocalDataDir());
        this.tokenResolver.setNextResolver(new RemoteResolver(connectionManager.getServiceEndpoint()));
        this.needToken = needToken;
    }

    RequestInterceptor(ConnectionManager connectionManager) {
        this(connectionManager, true);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.needToken) {
            request = request.newBuilder().addHeader("Authorization", this.getAuthToken().getCanonicalizedAccessToken()).build();
        }
        return this.handleResponse(chain.proceed(request));
    }

    private Response handleResponse(Response response) throws IOException {
        if (!response.isSuccessful()) {
            this.handleResponseErrorCode(response.code());
        }
        return response;
    }

    private void handleResponseErrorCode(int code) throws IOException {
        if (this.needToken && code == 401) {
            this.tokenResolver.invalidateToken();
        }
        throw new HttpFailedException(code, HiveResponseBody.getHttpErrorMessages().getOrDefault(code, "Unknown error."));
    }

    public AuthToken getAuthToken() throws HttpFailedException {
        return this.tokenResolver.getToken();
    }
}

