/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.connection;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.elastos.hive.utils.LogUtil;

public class LoggerInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        LogUtil.d("request ->" + request.method() + ", url->" + request.url().toString());
        LogUtil.d("request headers->" + request.headers().toString());
        RequestBody requestBody = request.body();
        String rbString = null;
        if (requestBody != null) {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            Charset charset = Charset.defaultCharset();
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                charset = contentType.charset(charset);
            }
            if (charset != null) {
                rbString = buffer.readString(charset);
            }
        }
        if (rbString != null && !rbString.equals("")) {
            LogUtil.d("request body->" + rbString);
        }
        Response response = chain.proceed(request);
        LogUtil.d("response headers ->" + response.headers().toString());
        ResponseBody responseBody = response.body();
        String rbBody = null;
        if (responseBody != null) {
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            Charset charset = Charset.defaultCharset();
            MediaType contentType = responseBody.contentType();
            if (contentType != null) {
                try {
                    charset = contentType.charset(charset);
                }
                catch (UnsupportedCharsetException e) {
                    e.printStackTrace();
                }
            }
            if (charset != null) {
                rbBody = buffer.clone().readString(charset);
            }
        }
        LogUtil.d("response Code ->" + response.code());
        if (rbBody != null && !rbBody.equals("")) {
            LogUtil.d("response body ->" + rbBody);
        }
        if (Objects.requireNonNull(response.header("Content-Type")).equals("text/html; charset=utf-8")) {
            try {
                response.peekBody(0L);
                response.newBuilder().headers(response.headers()).message(response.message()).body(ResponseBody.create(null, (String)"")).build();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return response;
    }
}

