/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.connection.LoggerInterceptor;
import org.elastos.hive.connection.RequestInterceptor;
import org.elastos.hive.connection.StringConverterFactory;
import org.elastos.hive.network.AuthApi;
import org.elastos.hive.network.BackupApi;
import org.elastos.hive.network.DatabaseApi;
import org.elastos.hive.network.FilesApi;
import org.elastos.hive.network.NodeManageApi;
import org.elastos.hive.network.PaymentApi;
import org.elastos.hive.network.ScriptingApi;
import org.elastos.hive.network.SubscriptionApi;
import org.elastos.hive.network.response.HiveResponseBody;
import org.elastos.hive.utils.LogUtil;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ConnectionManager {
    private static final int DEFAULT_TIMEOUT = 30;
    private ServiceEndpoint serviceEndpoint;
    private RequestInterceptor authRequestInterceptor;
    private RequestInterceptor plainRequestInterceptor;
    private SubscriptionApi subscriptionApi;
    private PaymentApi paymentApi;
    private DatabaseApi databaseApi;
    private AuthApi authApi;
    private FilesApi filesApi;
    private ScriptingApi scriptingApi;
    private BackupApi backupApi;
    private NodeManageApi nodeManageApi;

    public ConnectionManager(ServiceEndpoint serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        this.plainRequestInterceptor = new RequestInterceptor(this);
        this.authRequestInterceptor = new RequestInterceptor(this, false);
    }

    public ServiceEndpoint getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public AuthApi getAuthApi() {
        if (this.authApi == null) {
            this.authApi = ConnectionManager.createService(AuthApi.class, this.serviceEndpoint.getProviderAddress(), this.authRequestInterceptor);
        }
        return this.authApi;
    }

    public NodeManageApi getNodeManagerApi() {
        if (this.nodeManageApi == null) {
            this.nodeManageApi = ConnectionManager.createService(NodeManageApi.class, this.serviceEndpoint.getProviderAddress(), this.authRequestInterceptor);
        }
        return this.nodeManageApi;
    }

    public FilesApi getFilesApi() {
        if (this.filesApi == null) {
            this.filesApi = ConnectionManager.createService(FilesApi.class, this.serviceEndpoint.getProviderAddress(), this.plainRequestInterceptor);
        }
        return this.filesApi;
    }

    public SubscriptionApi getSubscriptionApi() {
        if (this.subscriptionApi == null) {
            this.subscriptionApi = ConnectionManager.createService(SubscriptionApi.class, this.serviceEndpoint.getProviderAddress(), this.plainRequestInterceptor);
        }
        return this.subscriptionApi;
    }

    public PaymentApi getPaymentApi() {
        if (this.paymentApi == null) {
            this.paymentApi = ConnectionManager.createService(PaymentApi.class, this.serviceEndpoint.getProviderAddress(), this.plainRequestInterceptor);
        }
        return this.paymentApi;
    }

    public DatabaseApi getDatabaseApi() {
        if (this.databaseApi == null) {
            this.databaseApi = ConnectionManager.createService(DatabaseApi.class, this.serviceEndpoint.getProviderAddress(), this.plainRequestInterceptor);
        }
        return this.databaseApi;
    }

    public ScriptingApi getScriptingApi() {
        if (this.scriptingApi == null) {
            this.scriptingApi = ConnectionManager.createService(ScriptingApi.class, this.serviceEndpoint.getProviderAddress(), this.plainRequestInterceptor);
        }
        return this.scriptingApi;
    }

    public BackupApi getBackupApi() {
        if (this.backupApi == null) {
            this.backupApi = ConnectionManager.createService(BackupApi.class, this.serviceEndpoint.getProviderAddress(), this.plainRequestInterceptor);
        }
        return this.backupApi;
    }

    public HttpURLConnection openConnection(String path) throws IOException {
        String url = this.serviceEndpoint.getProviderAddress() + "/api/v1" + path;
        LogUtil.d("open connection with URL: " + url);
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(url).openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        httpURLConnection.setConnectTimeout(5000);
        httpURLConnection.setReadTimeout(5000);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Transfer-Encoding", "chunked");
        httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
        httpURLConnection.setRequestProperty("Authorization", this.plainRequestInterceptor.getAuthToken().getCanonicalizedAccessToken());
        httpURLConnection.setChunkedStreamingMode(0);
        return httpURLConnection;
    }

    public static void readConnection(HttpURLConnection httpURLConnection) throws IOException {
        StringBuilder result;
        int code = httpURLConnection.getResponseCode();
        if (code == 200) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            result = new StringBuilder();
            String line = "";
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0) continue;
                result.append(line.trim());
            }
        } else {
            throw HiveResponseBody.getHttpExceptionByCode(code, HiveResponseBody.getHttpErrorMessages().get(code));
        }
        LogUtil.d("connection", "response content: " + result.toString());
    }

    private static <S> S createService(Class<S> serviceClass, String baseUrl, RequestInterceptor requestInterceptor) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS);
        clientBuilder.interceptors().clear();
        clientBuilder.interceptors().add(requestInterceptor);
        clientBuilder.interceptors().add(new LoggerInterceptor());
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)StringConverterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        return (S)retrofitBuilder.client(clientBuilder.build()).build().create(serviceClass);
    }
}

