/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.auth;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.elastos.hive.auth.AuthToken;
import org.elastos.hive.auth.TokenResolver;
import org.elastos.hive.exception.HiveSdkException;
import org.elastos.hive.exception.HttpFailedException;
import org.elastos.hive.utils.CryptoUtil;
import org.elastos.hive.utils.LogUtil;

public class LocalResolver
implements TokenResolver {
    public static final String TYPE_AUTH_TOKEN = "auth_token";
    public static final String TYPE_BACKUP_CREDENTIAL = "backup_credential";
    private static final String TOKEN_FOLDER = "/tokens";
    private String type;
    private String tokenPath;
    private TokenResolver nextResolver;
    private AuthToken token;

    public LocalResolver(String userDid, String providerAddress, String type, String cacheDir) {
        this.type = type;
        String rootDir = cacheDir + TOKEN_FOLDER;
        File root = new File(rootDir);
        if (!root.exists() && !root.mkdirs()) {
            throw new HiveSdkException("Cannot create token root path.");
        }
        this.tokenPath = String.format("%s/%s", rootDir, CryptoUtil.getSHA256(userDid + providerAddress + type));
    }

    @Override
    public AuthToken getToken() throws HttpFailedException {
        if (this.token == null) {
            this.token = this.restoreToken();
        }
        if (this.token == null || this.token.isExpired()) {
            this.token = this.nextResolver.getToken();
            this.saveToken(this.token);
        }
        return this.token;
    }

    @Override
    public void invalidateToken() {
        if (this.token != null) {
            this.token = null;
            this.clearToken();
        }
    }

    @Override
    public void setNextResolver(TokenResolver resolver) {
        this.nextResolver = resolver;
    }

    private AuthToken restoreToken() {
        Path path = Paths.get(this.tokenPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            LogUtil.d("Restore access token  from local cache");
            return (AuthToken)new Gson().fromJson(new String(Files.readAllBytes(path)), AuthToken.class);
        }
        catch (IOException e) {
            LogUtil.e("Failed to restore access token from local cache");
            return null;
        }
    }

    private void saveToken(AuthToken token) {
        Path path = Paths.get(this.tokenPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            // empty if block
        }
        try {
            Files.write(path, new Gson().toJson((Object)token).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            LogUtil.e("Failed to save access token to local cache");
            e.printStackTrace();
        }
    }

    private void clearToken() {
        try {
            Files.deleteIfExists(Paths.get(this.tokenPath, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

