/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.auth;

import java.util.concurrent.ExecutionException;
import org.elastos.hive.AppContextProvider;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.auth.AuthToken;
import org.elastos.hive.auth.TokenResolver;
import org.elastos.hive.connection.ConnectionManager;
import org.elastos.hive.exception.HttpFailedException;
import org.elastos.hive.service.BackupContext;
import org.elastos.hive.vault.AuthenticationServiceRender;

public class BackupRemoteResolver
implements TokenResolver {
    private AppContextProvider contextProvider;
    private BackupContext backupContext;
    private ConnectionManager connectionManager;
    private String targetDid;
    private String targetHost;
    private AuthenticationServiceRender authenticationService;

    public BackupRemoteResolver(ServiceEndpoint serviceEndpoint, BackupContext backupContext, String targetServiceDid, String targetAddress) {
        this.contextProvider = serviceEndpoint.getAppContext().getAppContextProvider();
        this.backupContext = backupContext;
        this.connectionManager = serviceEndpoint.getConnectionManager();
        this.targetDid = targetServiceDid;
        this.targetHost = targetAddress;
        this.authenticationService = new AuthenticationServiceRender(serviceEndpoint);
    }

    @Override
    public AuthToken getToken() throws HttpFailedException {
        try {
            return this.credential(this.authenticationService.signIn4Issuer());
        }
        catch (Exception e) {
            throw new HttpFailedException(401, "Failed to authentication backup credential.");
        }
    }

    private AuthToken credential(String sourceDid) throws ExecutionException, InterruptedException {
        return new AuthToken(this.backupContext.getAuthorization(sourceDid, this.targetDid, this.targetHost).get(), 0L, "backup");
    }

    @Override
    public void invalidateToken() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNextResolver(TokenResolver resolver) {
        throw new UnsupportedOperationException();
    }
}

