/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.elastos.hive.AppContext;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.service.BackupService;
import org.elastos.hive.service.DatabaseService;
import org.elastos.hive.service.FilesService;
import org.elastos.hive.service.PubSubService;
import org.elastos.hive.service.ScriptingService;
import org.elastos.hive.vault.HttpExceptionHandler;
import org.elastos.hive.vault.NodeManageServiceRender;
import org.elastos.hive.vault.ServiceBuilder;

public class Vault
extends ServiceEndpoint
implements HttpExceptionHandler {
    private FilesService filesService = new ServiceBuilder(this).createFilesService();
    private DatabaseService databaseService = new ServiceBuilder(this).createDatabase();
    private ScriptingService scriptingService;
    private PubSubService pubsubService = new ServiceBuilder(this).createPubsubService();
    private BackupService backupService = new ServiceBuilder(this).createBackupService();
    private NodeManageServiceRender nodeManageService;

    public Vault(AppContext context, String providerAddress) {
        this(context, providerAddress, null, null);
    }

    public Vault(AppContext context, String providerAddress, String targetDid, String targetAppDid) {
        super(context, providerAddress, targetDid, targetAppDid);
        this.scriptingService = new ServiceBuilder(this).createScriptingService();
        this.nodeManageService = new NodeManageServiceRender(this);
    }

    public FilesService getFilesService() {
        return this.filesService;
    }

    public DatabaseService getDatabaseService() {
        return this.databaseService;
    }

    public ScriptingService getScriptingService() {
        return this.scriptingService;
    }

    public PubSubService getPubSubService() {
        return this.pubsubService;
    }

    public BackupService getBackupService() {
        return this.backupService;
    }

    public CompletableFuture<String> getVersion() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.nodeManageService.getVersion();
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    public CompletableFuture<String> getCommitHash() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.nodeManageService.getCommitHash();
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }
}

