/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.elastos.hive.AppContext;
import org.elastos.hive.ServiceEndpoint;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.network.response.VaultInfoResponseBody;
import org.elastos.hive.payment.Order;
import org.elastos.hive.payment.PricingPlan;
import org.elastos.hive.payment.Receipt;
import org.elastos.hive.service.PaymentService;
import org.elastos.hive.service.SubscriptionService;
import org.elastos.hive.vault.HttpExceptionHandler;
import org.elastos.hive.vault.PaymentServiceRender;
import org.elastos.hive.vault.SubscriptionServiceRender;

public class BackupSubscription
extends ServiceEndpoint
implements SubscriptionService<BackupInfo>,
PaymentService,
HttpExceptionHandler {
    private SubscriptionServiceRender subscriptionService;
    private PaymentServiceRender paymentService = new PaymentServiceRender(this);

    public BackupSubscription(AppContext context, String providerAddress) throws HiveException {
        super(context, providerAddress);
        this.subscriptionService = new SubscriptionServiceRender(this);
    }

    @Override
    public CompletableFuture<BackupInfo> subscribe(String pricingPlan) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.subscriptionService.subscribeBackup();
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        }).thenApplyAsync(result -> {
            try {
                return this.getBackupInfoByResponseBody(this.subscriptionService.getBackupVaultInfo());
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    private BackupInfo getBackupInfoByResponseBody(VaultInfoResponseBody body) {
        return new BackupInfo().setDid(body.getDid()).setMaxStorage(body.getMaxStorage()).setFileUseStorage(body.getFileUseStorage()).setDbUseStorage(body.getDbUseStorage()).setModifyTime(body.getModifyTimeStr()).setStartTime(body.getStartTimeStr()).setEndTime(body.getEndTimeStr()).setPricingUsing(body.getPricingUsing()).setIsExisting(body.isExisting());
    }

    @Override
    public CompletableFuture<Void> unsubscribe() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Void> activate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Void> deactivate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<BackupInfo> checkSubscription() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.getBackupInfoByResponseBody(this.subscriptionService.getBackupVaultInfo());
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public CompletableFuture<List<PricingPlan>> getPricingPlanList() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.paymentService.getBackupPlanList();
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public CompletableFuture<PricingPlan> getPricingPlan(String planName) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.paymentService.getBackupPlan(planName);
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public CompletableFuture<Order> placeOrder(String planName) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.paymentService.getOrderInfo(this.paymentService.createBackupOrder(planName));
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public CompletableFuture<Order> getOrder(String orderId) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.paymentService.getOrderInfo(orderId);
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public CompletableFuture<Receipt> payOrder(String orderId, List<String> transIds) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.paymentService.payOrder(orderId, transIds);
                return null;
            }
            catch (Exception e) {
                throw new CompletionException(this.convertException(e));
            }
        });
    }

    @Override
    public CompletableFuture<Receipt> getReceipt(String receiptId) {
        throw new UnsupportedOperationException();
    }

    public class BackupInfo {
        private String did;
        private long maxStorage;
        private long fileUseStorage;
        private long dbUseStorage;
        private String modifyTime;
        private String startTime;
        private String endTime;
        private String pricingUsing;
        private boolean isExisting;

        public String getDid() {
            return this.did;
        }

        public BackupInfo setDid(String did) {
            this.did = did;
            return this;
        }

        public long getMaxStorage() {
            return this.maxStorage;
        }

        public BackupInfo setMaxStorage(long maxStorage) {
            this.maxStorage = maxStorage;
            return this;
        }

        public long getFileUseStorage() {
            return this.fileUseStorage;
        }

        public BackupInfo setFileUseStorage(long fileUseStorage) {
            this.fileUseStorage = fileUseStorage;
            return this;
        }

        public long getDbUseStorage() {
            return this.dbUseStorage;
        }

        public BackupInfo setDbUseStorage(long dbUseStorage) {
            this.dbUseStorage = dbUseStorage;
            return this;
        }

        public String getModifyTime() {
            return this.modifyTime;
        }

        public BackupInfo setModifyTime(String modifyTime) {
            this.modifyTime = modifyTime;
            return this;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public BackupInfo setStartTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public BackupInfo setEndTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public String getPricingUsing() {
            return this.pricingUsing;
        }

        public BackupInfo setPricingUsing(String pricingUsing) {
            this.pricingUsing = pricingUsing;
            return this;
        }

        public boolean getIsExisting() {
            return this.isExisting;
        }

        public BackupInfo setIsExisting(boolean isExisting) {
            this.isExisting = isExisting;
            return this;
        }
    }
}

