/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.elastos.did.DID;
import org.elastos.did.DIDBackend;
import org.elastos.did.DIDDocument;
import org.elastos.did.backend.ResolverCache;
import org.elastos.did.exception.DIDResolveException;
import org.elastos.did.exception.MalformedDIDException;
import org.elastos.hive.AppContextProvider;
import org.elastos.hive.exception.BadContextProviderException;
import org.elastos.hive.exception.DIDResolverNotSetupException;
import org.elastos.hive.exception.DIDResolverSetupException;
import org.elastos.hive.exception.DIDResoverAlreadySetupException;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.IllegalDidFormatException;
import org.elastos.hive.exception.ProviderNotFoundException;
import org.elastos.hive.exception.ProviderNotSetException;

public class AppContext {
    private static boolean resolverHasSetup = false;
    private AppContextProvider contextProvider;
    private String userDid;

    private AppContext(AppContextProvider provider) {
        this(provider, null);
    }

    private AppContext(AppContextProvider provider, String userDid) {
        this.userDid = userDid;
        this.contextProvider = provider;
    }

    public static void setupResolver(String resolver, String cacheDir) throws HiveException {
        if (cacheDir == null || resolver == null) {
            throw new IllegalArgumentException("invalid value for parameter resolver or cacheDir");
        }
        if (resolverHasSetup) {
            throw new DIDResoverAlreadySetupException();
        }
        try {
            DIDBackend.initialize((String)resolver, (String)cacheDir);
            ResolverCache.reset();
            resolverHasSetup = true;
        }
        catch (DIDResolveException e) {
            throw new DIDResolverSetupException(e.getMessage());
        }
    }

    public AppContextProvider getAppContextProvider() {
        return this.contextProvider;
    }

    public String getUserDid() {
        return this.userDid;
    }

    public static AppContext build(AppContextProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Missing AppContext provider");
        }
        if (provider.getLocalDataDir() == null) {
            throw new BadContextProviderException("Missing method to acquire data location");
        }
        if (provider.getAppInstanceDocument() == null) {
            throw new BadContextProviderException("Missing method to acquire App instance DID document");
        }
        if (!resolverHasSetup) {
            throw new DIDResolverNotSetupException();
        }
        return new AppContext(provider);
    }

    public static AppContext build(AppContextProvider provider, String userDid) {
        if (provider == null) {
            throw new IllegalArgumentException("Missing AppContext provider");
        }
        if (provider.getLocalDataDir() == null) {
            throw new BadContextProviderException("Missing method to acquire data location");
        }
        if (provider.getAppInstanceDocument() == null) {
            throw new BadContextProviderException("Missing method to acquire App instance DID document");
        }
        if (!resolverHasSetup) {
            throw new DIDResolverNotSetupException();
        }
        return new AppContext(provider, userDid);
    }

    public static CompletableFuture<String> getProviderAddress(String targetDid) {
        return AppContext.getProviderAddress(targetDid, null);
    }

    public static CompletableFuture<String> getProviderAddress(String targetDid, String preferredProviderAddress) {
        if (targetDid == null) {
            throw new IllegalArgumentException("Missing input parameter for target Did");
        }
        return CompletableFuture.supplyAsync(() -> {
            if (preferredProviderAddress != null) {
                return preferredProviderAddress;
            }
            try {
                List services = null;
                DID did = new DID(targetDid);
                DIDDocument doc = did.resolve();
                if (doc == null) {
                    throw new ProviderNotFoundException(String.format("The DID %s has not published onto sideChain", targetDid));
                }
                services = doc.selectServices((String)null, "HiveVault");
                if (services == null || services.size() == 0) {
                    throw new ProviderNotSetException(String.format("No 'HiveVault' services declared on DID document %s", targetDid));
                }
                return ((DIDDocument.Service)services.get(0)).getServiceEndpoint();
            }
            catch (MalformedDIDException e) {
                throw new IllegalDidFormatException("Bad target did: " + targetDid);
            }
            catch (DIDResolveException e) {
                return null;
            }
        });
    }
}

