/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.scripting;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.elastos.hive.exception.HiveException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "name", "output", "body"})
public abstract class Executable {
    private String type;
    private String name;
    private boolean output;

    protected Executable(String type, String name) {
        this.type = type;
        this.name = name;
    }

    protected Executable(String type, String name, boolean output) {
        this.type = type;
        this.name = name;
        this.output = output;
    }

    @JsonGetter(value="type")
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="output")
    public boolean getOutput() {
        return this.output;
    }

    @JsonGetter(value="body")
    public abstract Object getBody();

    public String serialize() throws HiveException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writer().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new HiveException(e);
        }
    }
}

