/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.scripting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elastos.hive.scripting.Executable;
import org.elastos.hive.scripting.RawExecutable;

public class AggregatedExecutable
extends Executable {
    private static final String TYPE = "aggregated";
    private List<Executable> executables = new ArrayList<Executable>();

    public AggregatedExecutable(String name) {
        this(name, (Executable[])null);
    }

    public AggregatedExecutable(String name, Executable[] executables) {
        this(name, executables, false);
    }

    public AggregatedExecutable(String name, Executable[] executables, boolean output) {
        super(TYPE, name);
        if (executables != null && executables.length > 0) {
            this.executables.addAll(Arrays.asList(executables));
        }
    }

    public AggregatedExecutable append(Executable executable) {
        if (executable instanceof AggregatedExecutable) {
            AggregatedExecutable ae = (AggregatedExecutable)executable;
            this.executables.addAll(ae.executables);
        } else {
            if (executable instanceof RawExecutable) {
                throw new UnsupportedOperationException("Can not handle the RawExecutable");
            }
            this.executables.add(executable);
        }
        return this;
    }

    public Executable[] getBody() {
        return this.executables.toArray(new Executable[0]);
    }
}

