/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.didhelper;

import java.util.concurrent.CompletableFuture;
import org.elastos.did.DIDDocument;
import org.elastos.did.Mnemonic;
import org.elastos.did.exception.DIDException;
import org.elastos.hive.ApplicationContext;
import org.elastos.hive.Client;
import org.elastos.hive.didhelper.PresentationInJWT;
import org.elastos.hive.exception.HiveException;

public final class VaultAuthHelper {
    private PresentationInJWT presentationInJWT;
    private String localDataDir;

    public static VaultAuthHelper createInstance(String userMnemonic, String appMnemonic, String localDataDir) {
        return new VaultAuthHelper(userMnemonic, appMnemonic, localDataDir);
    }

    public VaultAuthHelper(String userMnemonic, String appMnemonic, String localDataDir) {
        PresentationInJWT.Options userDidOpt = PresentationInJWT.Options.create().setMnemonic(userMnemonic).setStorepass("storepass");
        PresentationInJWT.Options appInstanceDidOpt = PresentationInJWT.Options.create().setMnemonic(appMnemonic).setStorepass("storepass");
        this.presentationInJWT = new PresentationInJWT().init(userDidOpt, appInstanceDidOpt);
        this.localDataDir = localDataDir;
    }

    public static String generateMnemonic(String language) throws DIDException {
        Mnemonic mg = Mnemonic.getInstance((String)language);
        return mg.generate();
    }

    public CompletableFuture<Client> getClientWithAuth() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return Client.createInstance(new ApplicationContext(){

                    @Override
                    public String getLocalDataDir() {
                        return VaultAuthHelper.this.localDataDir;
                    }

                    @Override
                    public DIDDocument getAppInstanceDocument() {
                        return VaultAuthHelper.this.getAppDIDDocument();
                    }

                    @Override
                    public CompletableFuture<String> getAuthorization(String jwtToken) {
                        return VaultAuthHelper.this.generateAuthPresentationJWT(jwtToken);
                    }
                });
            }
            catch (HiveException e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    public CompletableFuture<String> generateAuthPresentationJWT(String challengeJwtToken) {
        return CompletableFuture.supplyAsync(() -> this.presentationInJWT.getAuthToken(challengeJwtToken));
    }

    public DIDDocument getAppDIDDocument() {
        return this.presentationInJWT.getDoc();
    }
}

