/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.didhelper;

import java.util.Calendar;
import java.util.HashMap;
import org.elastos.did.Issuer;
import org.elastos.did.VerifiableCredential;
import org.elastos.did.exception.DIDException;
import org.elastos.hive.didhelper.DApp;
import org.elastos.hive.didhelper.Entity;

class DIDApp
extends Entity {
    private Issuer issuer = new Issuer(this.getDocument());

    public DIDApp(String name, String mnemonic, String phrasepass, String storepass) throws DIDException {
        super(name, mnemonic, phrasepass, storepass);
    }

    public VerifiableCredential issueDiplomaFor(DApp dapp) throws DIDException {
        HashMap<String, String> subject = new HashMap<String, String>();
        subject.put("appDid", dapp.appId);
        Calendar exp = Calendar.getInstance();
        exp.add(1, 5);
        VerifiableCredential.Builder cb = this.issuer.issueFor(dapp.getDid());
        VerifiableCredential vc = cb.id("didapp").type(new String[]{"AppIdCredential"}).properties(subject).expirationDate(exp.getTime()).seal(this.getStorePassword());
        System.out.println("VerifiableCredential:");
        String vcStr = vc.toString();
        System.out.println(vcStr);
        return vc;
    }
}

