/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.didhelper;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.elastos.did.DID;
import org.elastos.did.DIDStore;
import org.elastos.did.VerifiableCredential;
import org.elastos.did.VerifiablePresentation;
import org.elastos.did.exception.DIDException;
import org.elastos.hive.didhelper.Entity;

class DApp
extends Entity {
    public String appId = "appId";

    public DApp(String name, String mnemonic, String phrasepass, String storepass) throws DIDException {
        super(name, mnemonic, phrasepass, storepass);
    }

    public VerifiablePresentation createPresentation(VerifiableCredential vc, String realm, String nonce) throws DIDException {
        VerifiablePresentation.Builder vpb = VerifiablePresentation.createFor((DID)this.getDid(), (DIDStore)this.getDIDStore());
        ArrayList<VerifiableCredential> vcs = new ArrayList<VerifiableCredential>(1);
        vcs.add(vc);
        VerifiablePresentation vp = vpb.credentials(vcs.toArray(new VerifiableCredential[vcs.size()])).realm(realm).nonce(nonce).seal(this.getStorePassword());
        System.out.println("VerifiablePresentation:");
        String vpStr = vp.toString();
        System.out.println(vpStr);
        return vp;
    }

    public String createToken(VerifiablePresentation vp, String hiveDid) throws DIDException {
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        Date iat = cal.getTime();
        Date nbf = cal.getTime();
        cal.add(2, 3);
        Date exp = cal.getTime();
        String token = this.getDocument().jwtBuilder().addHeader("typ", (Object)"JWT").addHeader("version", (Object)"1.0").setSubject("DIDAuthResponse").setAudience(hiveDid).setIssuedAt(iat).setExpiration(exp).setNotBefore(nbf).claimWithJson("presentation", vp.toString()).sign(this.storepass).compact();
        System.out.println("JWT Token:");
        System.out.println("  " + token);
        return token;
    }
}

