/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.database;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elastos.hive.database.Collation;
import org.elastos.hive.database.Index;
import org.elastos.hive.database.Options;

public class DeleteOptions
extends Options<DeleteOptions> {
    @JsonProperty(value="collation")
    private Collation collation;
    @JsonProperty(value="hint")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED})
    private List<Index> hint;

    public DeleteOptions(Collation collation, Index hint) {
        this.collation(collation);
        this.hint(hint);
    }

    public DeleteOptions(Collation collation, List<Index> hint) {
        this.collation(collation);
        this.hint(hint);
    }

    public DeleteOptions() {
    }

    public DeleteOptions collation(Collation value) {
        this.collation = value;
        return this;
    }

    public Collation collation() {
        return this.collation;
    }

    public DeleteOptions hint(Index value) {
        if (value == null) {
            this.hint = null;
        } else {
            if (this.hint == null) {
                this.hint = new ArrayList<Index>();
            }
            this.hint.add(value);
        }
        return this;
    }

    public DeleteOptions hint(List<Index> value) {
        if (value == null || value.isEmpty()) {
            this.hint = null;
        } else {
            if (this.hint == null) {
                this.hint = new ArrayList<Index>();
            }
            this.hint.addAll(value);
        }
        return this;
    }

    public DeleteOptions hint(Index[] value) {
        if (value == null || value.length == 0) {
            this.hint = null;
        } else {
            if (this.hint == null) {
                this.hint = new ArrayList<Index>();
            }
            this.hint.addAll(Arrays.asList(value));
        }
        return this;
    }

    public List<Index> hint() {
        return this.hint;
    }

    public static DeleteOptions deserialize(String content) {
        return DeleteOptions.deserialize(content, DeleteOptions.class);
    }
}

