/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.connection;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.elastos.hive.connection.model.HeaderConfig;

public class HeaderInterceptor
implements Interceptor {
    private static final String AUTHORIZATION = "Authorization";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private final HeaderConfig headerConfig;

    HeaderInterceptor(HeaderConfig headerConfig) {
        this.headerConfig = headerConfig;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request newRequest = this.addAuthHeader(request);
        newRequest = newRequest != null ? this.addContentTypeHeader(newRequest) : this.addContentTypeHeader(request);
        if ((newRequest = newRequest != null ? this.addAcceptEncoding(newRequest) : this.addAcceptEncoding(request)) != null) {
            return chain.proceed(newRequest);
        }
        return chain.proceed(request);
    }

    private Request addAuthHeader(Request realRequest) {
        if (this.headerConfig == null || this.headerConfig.getAuthToken() == null) {
            return realRequest;
        }
        return realRequest.newBuilder().addHeader(AUTHORIZATION, this.headerConfig.getAuthToken().getTokenType() + " " + this.headerConfig.getAuthToken().getAccessToken()).build();
    }

    private Request addContentTypeHeader(Request realRequest) {
        if (this.headerConfig == null || this.headerConfig.getContentType() == null) {
            return realRequest;
        }
        return realRequest.newBuilder().addHeader(CONTENT_TYPE, this.headerConfig.getContentType()).build();
    }

    private Request addAcceptEncoding(Request realRequest) {
        if (this.headerConfig == null || this.headerConfig.getAcceptEncoding() == null) {
            return realRequest;
        }
        return realRequest.newBuilder().addHeader(ACCEPT_ENCODING, this.headerConfig.getAcceptEncoding()).build();
    }
}

