/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.connection;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.elastos.hive.connection.BaseServiceUtil;
import org.elastos.hive.connection.model.BaseServiceConfig;
import org.elastos.hive.network.AuthApi;
import org.elastos.hive.network.DatabaseApi;
import org.elastos.hive.network.FilesApi;
import org.elastos.hive.network.PaymentApi;
import org.elastos.hive.network.ScriptingApi;
import org.elastos.hive.network.VaultApi;
import org.elastos.hive.network.VersionApi;

public class ConnectionManager {
    private AuthApi authApi;
    private FilesApi fileApi;
    private DatabaseApi databaseApi;
    private VersionApi versionApi;
    private ScriptingApi scriptingApi;
    private PaymentApi paymentApi;
    private VaultApi vaultApi;
    private String vaultBaseUrl;
    private BaseServiceConfig vaultConfig = new BaseServiceConfig.Builder().build();

    public ConnectionManager(String baseUrl, BaseServiceConfig baseServiceConfig) {
        this.resetVaultApi(baseUrl, baseServiceConfig);
    }

    public AuthApi getAuthApi() {
        if (this.authApi == null) {
            this.authApi = BaseServiceUtil.createService(AuthApi.class, this.vaultBaseUrl, this.vaultConfig);
        }
        return this.authApi;
    }

    public FilesApi getFileApi() {
        if (this.fileApi == null) {
            this.fileApi = BaseServiceUtil.createService(FilesApi.class, this.vaultBaseUrl, this.vaultConfig);
        }
        return this.fileApi;
    }

    public DatabaseApi getDatabaseApi() {
        if (this.databaseApi == null) {
            this.databaseApi = BaseServiceUtil.createService(DatabaseApi.class, this.vaultBaseUrl, this.vaultConfig);
        }
        return this.databaseApi;
    }

    public ScriptingApi getScriptingApi() {
        if (this.scriptingApi == null) {
            this.scriptingApi = BaseServiceUtil.createService(ScriptingApi.class, this.vaultBaseUrl, this.vaultConfig);
        }
        return this.scriptingApi;
    }

    public VersionApi getVersionApi() {
        if (this.versionApi == null) {
            this.versionApi = BaseServiceUtil.createService(VersionApi.class, this.vaultBaseUrl, this.vaultConfig);
        }
        return this.versionApi;
    }

    public PaymentApi getPaymentApi() {
        if (this.paymentApi == null) {
            this.paymentApi = BaseServiceUtil.createService(PaymentApi.class, this.vaultBaseUrl, this.vaultConfig);
        }
        return this.paymentApi;
    }

    public VaultApi getVaultApi() {
        if (this.vaultApi == null) {
            this.vaultApi = BaseServiceUtil.createService(VaultApi.class, this.vaultBaseUrl, this.vaultConfig);
        }
        return this.vaultApi;
    }

    private void updateVaultConfig(BaseServiceConfig vaultConfig) {
        this.vaultConfig = vaultConfig;
    }

    private void updateVaultBaseUrl(String vaultBaseUrl) {
        this.vaultBaseUrl = vaultBaseUrl;
    }

    public void resetVaultApi(String baseUrl, BaseServiceConfig baseServiceConfig) {
        this.authApi = null;
        this.fileApi = null;
        this.databaseApi = null;
        this.versionApi = null;
        this.scriptingApi = null;
        this.paymentApi = null;
        this.vaultApi = null;
        this.updateVaultBaseUrl(baseUrl);
        this.updateVaultConfig(baseServiceConfig);
    }

    public String getVaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    public String getAccessToken() {
        return this.vaultConfig.getHeaderConfig().getAuthToken().getAccessToken();
    }

    public HttpURLConnection openURLConnection(String path) throws IOException {
        String url = this.getVaultBaseUrl() + "/api/v1" + path;
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(url).openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        httpURLConnection.setConnectTimeout(5000);
        httpURLConnection.setReadTimeout(5000);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Transfer-Encoding", "chunked");
        httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
        httpURLConnection.setRequestProperty("Authorization", "token " + this.getAccessToken());
        httpURLConnection.setChunkedStreamingMode(0);
        return httpURLConnection;
    }
}

