/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive;

import com.fasterxml.jackson.databind.JsonNode;
import java.nio.file.ProviderNotFoundException;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.elastos.did.DID;
import org.elastos.did.DIDAdapter;
import org.elastos.did.DIDBackend;
import org.elastos.did.DIDDocument;
import org.elastos.did.DefaultDIDAdapter;
import org.elastos.did.exception.DIDException;
import org.elastos.hive.ApplicationContext;
import org.elastos.hive.AuthHelper;
import org.elastos.hive.AuthenticationAdapter;
import org.elastos.hive.HiveURLInfo;
import org.elastos.hive.Vault;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.exception.ProviderNotSetException;
import org.elastos.hive.exception.VaultAlreadyExistException;

public class Client {
    private static final String HIVE_URL_PREFIX = "hive://";
    private static boolean resolverDidSetup;
    private AuthenticationAdapter authenticationAdapter;
    private ApplicationContext context;

    private Client(ApplicationContext context) {
        this.context = context;
        this.authenticationAdapter = new AuthenticationAdapterImpl();
    }

    public static void setupResolver() throws HiveException {
        Client.setupResolver(null);
    }

    public static void setupResolver(String resolver) throws HiveException {
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        if (resolverDidSetup) {
            throw new HiveException("Resolver already setup before");
        }
        DIDBackend.initialize((DIDAdapter)new DefaultDIDAdapter(resolver));
        resolverDidSetup = true;
    }

    public static Client createInstance(ApplicationContext context) throws HiveException {
        if (context == null) {
            throw new IllegalArgumentException("Missing Application context");
        }
        if (context.getLocalDataDir() == null) {
            throw new IllegalArgumentException("Can not acquire data cache location from Application context");
        }
        if (context.getAppInstanceDocument() == null) {
            throw new IllegalArgumentException("Can not acquire App instance document from Application context");
        }
        if (!resolverDidSetup) {
            throw new HiveException("Setup DID resolver first");
        }
        return new Client(context);
    }

    public CompletableFuture<Vault> getVault(String ownerDid, String preferredProviderAddress) {
        return this.getVaultProvider(ownerDid, preferredProviderAddress).thenApplyAsync(provider -> {
            AuthHelper authHelper = new AuthHelper(this.context, ownerDid, (String)provider, this.authenticationAdapter);
            return new Vault(authHelper, (String)provider, ownerDid);
        });
    }

    public CompletableFuture<Vault> createVault(String ownerDid, String preferredProviderAddress) {
        return ((CompletableFuture)((CompletableFuture)this.getVaultProvider(ownerDid, preferredProviderAddress).thenApplyAsync(provider -> {
            AuthHelper authHelper = new AuthHelper(this.context, ownerDid, (String)provider, this.authenticationAdapter);
            return new Vault(authHelper, (String)provider, ownerDid);
        })).thenComposeAsync(vault -> vault.checkVaultExist())).thenComposeAsync(vault -> {
            if (null == vault) {
                throw new VaultAlreadyExistException("Vault already existed.");
            }
            return vault.requestToCreateVault();
        });
    }

    public CompletableFuture<String> getVaultProvider(String ownerDid, String preferredProviderAddress) {
        if (ownerDid == null) {
            throw new IllegalArgumentException("Missing ownerDid to get the provider for");
        }
        return CompletableFuture.supplyAsync(() -> {
            if (preferredProviderAddress != null) {
                return preferredProviderAddress;
            }
            try {
                List services = null;
                DID did = new DID(ownerDid);
                DIDDocument doc = did.resolve(true);
                if (doc == null) {
                    throw new ProviderNotFoundException(String.format("The DID document %s has not published", ownerDid));
                }
                services = doc.selectServices((String)null, "HiveVault");
                if (services == null || services.size() == 0) {
                    throw new ProviderNotSetException(String.format("No 'HiveVault' services declared on DID document %s", ownerDid));
                }
                return ((DIDDocument.Service)services.get(0)).getServiceEndpoint();
            }
            catch (DIDException e) {
                throw new CompletionException(new HiveException(e.getLocalizedMessage()));
            }
        });
    }

    public <T> CompletableFuture<T> callScriptUrl(String scriptUrl, Class<T> resultType) {
        return this.parseHiveURL(scriptUrl).thenComposeAsync(hiveURLInfo -> hiveURLInfo.callScript(resultType));
    }

    public <T> CompletableFuture<T> downloadFileByScriptUrl(String scriptUrl, Class<T> resultType) {
        return this.parseHiveURL(scriptUrl).thenComposeAsync(hiveURLInfo -> hiveURLInfo.downloadFile(resultType));
    }

    public CompletableFuture<HiveURLInfo> parseHiveURL(String scriptUrl) {
        return CompletableFuture.supplyAsync(() -> new HiveURLInfoImpl(scriptUrl));
    }

    class HiveURLInfoImpl
    implements HiveURLInfo {
        private String targetDid;
        private String appDid;
        private String scriptName;
        private String params;

        public HiveURLInfoImpl(String scriptUrl) {
            if (scriptUrl == null || !scriptUrl.startsWith(Client.HIVE_URL_PREFIX)) {
                throw new InvalidParameterException("Invalid hive script url: no hive prefix.");
            }
            String[] parts = scriptUrl.substring(Client.HIVE_URL_PREFIX.length()).split("/");
            if (parts.length < 2) {
                throw new InvalidParameterException("Invalid hive script url: must contain at least one slash.");
            }
            String[] dids = parts[0].split("@");
            if (dids.length != 2) {
                throw new InvalidParameterException("Invalid hive script url: must contain two dids.");
            }
            String[] values = scriptUrl.substring(Client.HIVE_URL_PREFIX.length() + parts[0].length() + 1).split("\\?params=");
            if (values.length != 2) {
                throw new InvalidParameterException("Invalid hive script url: must contain script name and params.");
            }
            this.targetDid = dids[0];
            this.appDid = dids[1];
            this.scriptName = values[0];
            this.params = values[1];
        }

        @Override
        public <T> CompletableFuture<T> callScript(Class<T> resultType) {
            return this.getVault().thenComposeAsync(vault -> vault.getScripting().callScriptUrl(this.scriptName, this.params, this.appDid, resultType));
        }

        @Override
        public <T> CompletableFuture<T> downloadFile(Class<T> resultType) {
            return this.getVault().thenCompose(vault -> vault.getScripting().callScriptUrl(this.scriptName, this.params, this.appDid, JsonNode.class).thenCompose(jsonNode -> vault.getScripting().downloadFile(this.getTransactionIdByJsonNode((JsonNode)jsonNode), resultType)));
        }

        private String getTransactionIdByJsonNode(JsonNode jsonNode) {
            JsonNode node = this.searchForEntity(jsonNode, "transaction_id");
            if (node == null) {
                throw new CompletionException(new InvalidParameterException("Can not get transaction id by running script."));
            }
            return node.asText();
        }

        private JsonNode searchForEntity(JsonNode node, String entityName) {
            if (node == null) {
                return null;
            }
            if (node.has(entityName)) {
                return node.get(entityName);
            }
            if (!node.isContainerNode()) {
                return null;
            }
            for (JsonNode child : node) {
                JsonNode childResult;
                if (!child.isContainerNode() || (childResult = this.searchForEntity(child, entityName)) == null || childResult.isMissingNode()) continue;
                return childResult;
            }
            return null;
        }

        @Override
        public CompletableFuture<Vault> getVault() {
            return Client.this.getVaultProvider(this.targetDid, null).thenApplyAsync(provider -> {
                AuthHelper authHelper = new AuthHelper(Client.this.context, this.targetDid, (String)provider, Client.this.authenticationAdapter);
                return new Vault(authHelper, (String)provider, this.targetDid);
            });
        }
    }

    private static class AuthenticationAdapterImpl
    implements AuthenticationAdapter {
        private AuthenticationAdapterImpl() {
        }

        @Override
        public synchronized CompletableFuture<String> getAuthorization(ApplicationContext context, String jwtToken) {
            return context.getAuthorization(jwtToken);
        }
    }
}

