/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.scripting;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import org.elastos.hive.scripting.Executable;

public class DbFindQuery
extends Executable {
    private static final String TYPE = "find";
    private Query query;

    public DbFindQuery(String name, String collection, JsonNode filter) {
        super(TYPE, name);
        this.query = new Query(collection, filter);
    }

    public DbFindQuery(String name, String collection, JsonNode filter, JsonNode options) {
        super(TYPE, name);
        this.query = new Query(collection, filter, options);
    }

    public DbFindQuery(String name, String collection, JsonNode filter, JsonNode options, boolean output) {
        super(TYPE, name, output);
        this.query = new Query(collection, filter, options);
    }

    @Override
    public Query getBody() {
        return this.query;
    }

    @JsonPropertyOrder(value={"collection", "filter"})
    public static class Query {
        private String collection;
        private JsonNode filter;
        private JsonNode options;

        public Query(String collection, JsonNode query) {
            this.collection = collection;
            this.filter = query;
        }

        public Query(String collection, JsonNode query, JsonNode options) {
            this.collection = collection;
            this.filter = query;
            this.options = options;
        }

        @JsonGetter(value="collection")
        public String getCollection() {
            return this.collection;
        }

        @JsonGetter(value="filter")
        public JsonNode getFilter() {
            return this.filter;
        }

        @JsonGetter(value="options")
        public JsonNode getOptions() {
            return this.options;
        }
    }
}

