/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.didhelper;

import java.io.File;
import java.util.List;
import org.elastos.did.DID;
import org.elastos.did.DIDDocument;
import org.elastos.did.DIDStore;
import org.elastos.did.RootIdentity;
import org.elastos.did.exception.DIDException;

class Entity {
    private String phrasepass;
    private RootIdentity identity;
    protected String storepass;
    private String name;
    private DIDStore store;
    private DID did;

    protected Entity(String name, String mnemonic, String phrasepass, String storepass) throws DIDException {
        this.phrasepass = phrasepass;
        this.storepass = storepass;
        this.name = name;
        this.initPrivateIdentity(mnemonic);
        this.initDid();
    }

    protected void initPrivateIdentity(String mnemonic) throws DIDException {
        String storePath = System.getProperty("user.dir") + File.separator + "didCache" + File.separator + this.name;
        this.store = DIDStore.open((String)storePath);
        String id = RootIdentity.getId((String)mnemonic, (String)this.phrasepass);
        this.identity = this.store.containsRootIdentity(id) ? this.store.loadRootIdentity(id) : RootIdentity.create((String)mnemonic, (String)this.phrasepass, (DIDStore)this.store, (String)this.storepass);
        this.identity.synchronize(0);
    }

    protected void initDid() throws DIDException {
        List dids = this.store.listDids();
        if (dids.size() > 0) {
            this.did = (DID)dids.get(0);
            return;
        }
        DIDDocument doc = this.identity.newDid(this.storepass);
        this.did = doc.getSubject();
        System.out.format("[%s] My new DID created: %s%n", this.name, this.did);
    }

    protected DIDStore getDIDStore() {
        return this.store;
    }

    public DID getDid() {
        return this.did;
    }

    public DIDDocument getDocument() throws DIDException {
        return this.store.loadDid(this.did);
    }

    public String getName() {
        return this.name;
    }

    protected String getStorePassword() {
        return this.storepass;
    }
}

