/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.database;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elastos.hive.database.Collation;
import org.elastos.hive.database.Index;
import org.elastos.hive.database.Options;

public class CountOptions
extends Options<CountOptions> {
    @JsonProperty(value="skip")
    private Long skip;
    @JsonProperty(value="limit")
    private Long limit;
    @JsonProperty(value="maxTimeMS")
    private Integer maxTimeMS;
    @JsonProperty(value="collation")
    private Collation collation;
    @JsonProperty(value="hint")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED})
    private List<Index> hint;

    public CountOptions(long skip, long limit) {
        this.skip(skip);
        this.limit(limit);
    }

    public CountOptions() {
    }

    public CountOptions skip(long value) {
        this.skip = value;
        return this;
    }

    public Long skip() {
        return this.skip;
    }

    public CountOptions limit(long value) {
        this.limit = value;
        return this;
    }

    public Long limit() {
        return this.limit;
    }

    public CountOptions maxTimeMS(int value) {
        this.maxTimeMS = value;
        return this;
    }

    public Integer maxTimeMS() {
        return this.maxTimeMS;
    }

    public CountOptions collation(Collation value) {
        this.collation = value;
        return this;
    }

    public Collation collation() {
        return this.collation();
    }

    public CountOptions hint(Index value) {
        if (value == null) {
            this.hint = null;
            return this;
        }
        if (this.hint == null) {
            this.hint = new ArrayList<Index>();
        }
        this.hint.add(value);
        return this;
    }

    public CountOptions hint(List<Index> value) {
        if (value == null || value.isEmpty()) {
            this.hint = null;
            return this;
        }
        if (this.hint == null) {
            this.hint = new ArrayList<Index>();
        }
        this.hint.addAll(value);
        return this;
    }

    public CountOptions hint(Index[] value) {
        if (value == null || value.length == 0) {
            this.hint = null;
            return this;
        }
        if (this.hint == null) {
            this.hint = new ArrayList<Index>();
        }
        this.hint.addAll(Arrays.asList(value));
        return this;
    }

    public List<Index> hint() {
        return this.hint;
    }

    public static CountOptions deserialize(String content) {
        return CountOptions.deserialize(content, CountOptions.class);
    }
}

