/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.elastos.hive.AuthHelper;
import org.elastos.hive.connection.ConnectionManager;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.utils.ResponseHelper;
import retrofit2.Response;

class VaultHelper {
    private AuthHelper authHelper;
    private ConnectionManager connectionManager;

    public VaultHelper(AuthHelper authHelper) {
        this.authHelper = authHelper;
        this.connectionManager = authHelper.getConnectionManager();
    }

    public CompletableFuture<Boolean> requestToCreateVault() {
        return this.authHelper.checkValid().thenApplyAsync(aVoid -> {
            try {
                return this.requestToCreateVaultImpl();
            }
            catch (HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    private boolean requestToCreateVaultImpl() throws HiveException {
        try {
            Response response = this.connectionManager.getVaultApi().createFreeVault().execute();
            this.authHelper.checkResponseWithRetry(response);
            return true;
        }
        catch (Exception e) {
            throw new HiveException(e.getLocalizedMessage());
        }
    }

    public CompletableFuture<Boolean> vaultExist() {
        return this.authHelper.checkValid().thenApplyAsync(aVoid -> {
            try {
                return this.vaultExistImpl();
            }
            catch (HiveException e) {
                throw new CompletionException(e);
            }
        });
    }

    private boolean vaultExistImpl() throws HiveException {
        try {
            Response response = this.connectionManager.getPaymentApi().getServiceInfo().execute();
            int code = response.code();
            if (404 == code) {
                return false;
            }
            this.authHelper.checkResponseWithRetry(response);
            JsonNode value = ResponseHelper.getValue(response, JsonNode.class);
            if (null == value) {
                return false;
            }
            JsonNode ret = value.get("vault_service_info");
            return null != ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e.getLocalizedMessage());
        }
    }
}

