/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;

public class ResponseHelper {
    public static byte[] getBuffer(Response response) {
        byte[] data = null;
        try {
            ResponseBody body = (ResponseBody)response.body();
            data = body != null ? body.bytes() : new byte[]{};
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    public static List<JsonNode> getArray(Response response, String key) {
        ArrayList<JsonNode> rets = new ArrayList<JsonNode>();
        rets.clear();
        try {
            String json = ResponseHelper.toString(response);
            JsonNode arrNode = new ObjectMapper().readTree(json).get(key);
            if (arrNode.isArray()) {
                for (JsonNode objNode : arrNode) {
                    rets.add(objNode);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rets;
    }

    public static <T> T getValue(String json, Class<T> clz) {
        if (null == json) {
            return null;
        }
        Object obj = null;
        try {
            obj = clz.isAssignableFrom(String.class) ? json : (clz.isAssignableFrom(byte[].class) ? (Object)json.getBytes() : (clz.isAssignableFrom(JsonNode.class) ? new ObjectMapper().readTree(json) : (clz.isAssignableFrom(Reader.class) ? new StringReader(json) : new ObjectMapper().readValue(json, clz))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)obj;
    }

    public static <T> T getValue(Response response, Class<T> clz) throws IOException {
        String json = ResponseHelper.toString(response);
        return ResponseHelper.getValue(json, clz);
    }

    public static String toString(Response response) throws IOException {
        ResponseBody body = (ResponseBody)response.body();
        return body != null ? body.string() : "";
    }

    public static long writeOutput(Response response, OutputStream outputStream) throws IOException {
        int ch;
        ResponseBody body = (ResponseBody)response.body();
        InputStream inputStream = body != null ? body.byteStream() : null;
        int length = 0;
        if (inputStream == null) {
            return length;
        }
        while ((ch = inputStream.read()) != -1) {
            ++length;
            outputStream.write(ch);
        }
        return length;
    }

    public static Reader getToReader(Response response) {
        InputStream inputStream;
        ResponseBody body = (ResponseBody)response.body();
        InputStream inputStream2 = inputStream = body != null ? body.byteStream() : null;
        if (inputStream == null) {
            return null;
        }
        return new InputStreamReader(inputStream);
    }

    public static InputStream getInputStream(Response response) {
        InputStream inputStream;
        ResponseBody body = (ResponseBody)response.body();
        InputStream inputStream2 = inputStream = body != null ? body.byteStream() : null;
        if (inputStream == null) {
            return null;
        }
        return inputStream;
    }

    public static void readConnection(HttpURLConnection httpURLConnection) {
        try {
            int code = httpURLConnection.getResponseCode();
            System.out.println("response code=" + code);
            String message = httpURLConnection.getResponseMessage();
            System.out.println("message=" + message);
            String sCurrentLine = "";
            String result = "";
            if (code == 200) {
                InputStream is = httpURLConnection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                while ((sCurrentLine = reader.readLine()) != null) {
                    if (sCurrentLine.length() <= 0) continue;
                    result = result + sCurrentLine.trim();
                }
            } else {
                result = "error code:" + code;
            }
            System.out.println("response content:" + result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

