/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.files;

import java.math.BigDecimal;
import org.elastos.hive.exception.UnsupportFileTypeException;
import org.elastos.hive.utils.DateUtil;

public class FileInfo {
    private String type;
    private String name;
    private long size;
    private String last_modify;

    public Type getType() {
        switch (this.type) {
            case "file": {
                return Type.FILE;
            }
            case "folder": {
                return Type.FOLDER;
            }
        }
        throw new UnsupportFileTypeException();
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public String getLastModified() {
        long timeStamp = new BigDecimal(this.last_modify).multiply(new BigDecimal(1000)).longValue();
        return DateUtil.getCurrentEpochTimeStamp(timeStamp);
    }

    public static enum Type {
        FILE,
        FOLDER;

    }
}

