/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.didhelper;

import org.elastos.did.DIDDocument;
import org.elastos.did.VerifiableCredential;
import org.elastos.did.VerifiablePresentation;
import org.elastos.did.jwt.Claims;
import org.elastos.hive.didhelper.DApp;
import org.elastos.hive.didhelper.DIDApp;
import org.elastos.hive.utils.JwtUtil;

class PresentationInJWT {
    DIDApp userDidApp = null;
    DApp appInstanceDidApp = null;
    DIDDocument doc = null;

    PresentationInJWT() {
    }

    public PresentationInJWT init(Options userDidOpt, Options appInstanceDidOpt) {
        try {
            this.userDidApp = new DIDApp(userDidOpt.name, userDidOpt.mnemonic, userDidOpt.phrasepass, userDidOpt.storepass);
            this.appInstanceDidApp = new DApp(appInstanceDidOpt.name, appInstanceDidOpt.mnemonic, appInstanceDidOpt.phrasepass, appInstanceDidOpt.storepass);
            this.doc = this.appInstanceDidApp.getDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public DIDDocument getDoc() {
        return this.doc;
    }

    public String getAuthToken(String jwtToken) {
        try {
            Claims claims = JwtUtil.getBody(jwtToken);
            String iss = claims.getIssuer();
            String nonce = (String)claims.get((Object)"nonce");
            VerifiableCredential vc = this.userDidApp.issueDiplomaFor(this.appInstanceDidApp);
            VerifiablePresentation vp = this.appInstanceDidApp.createPresentation(vc, iss, nonce);
            String token = this.appInstanceDidApp.createToken(vp, iss);
            return token;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class Options {
        private String name;
        private String mnemonic;
        private String phrasepass;
        private String storepass;

        public static Options create() {
            return new Options();
        }

        public Options setName(String name) {
            this.name = name;
            return this;
        }

        public Options setMnemonic(String mnemonic) {
            this.mnemonic = mnemonic;
            return this;
        }

        public Options setPhrasepass(String phrasepass) {
            this.phrasepass = phrasepass;
            return this;
        }

        public Options setStorepass(String storepass) {
            this.storepass = storepass;
            return this;
        }
    }
}

