/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class Index {
    private String key;
    private Order order;

    public Index(String key, Order order) {
        this.key = key;
        this.order = order;
    }

    public String getKey() {
        return this.key;
    }

    public Order getOrder() {
        return this.order;
    }

    static class Deserializer
    extends StdDeserializer<Index> {
        private static final long serialVersionUID = -6327506026962351443L;

        public Deserializer() {
            this(null);
        }

        public Deserializer(Class<?> t) {
            super(t);
        }

        public Index deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            if (node.size() != 1) {
                throw ctxt.weirdNativeValueException((Object)node, Index.class);
            }
            Iterator it = node.fields();
            Map.Entry field = (Map.Entry)it.next();
            String key = (String)field.getKey();
            Order order = Order.fromInt(((JsonNode)field.getValue()).asInt());
            return new Index(key, order);
        }
    }

    static class Serializer
    extends StdSerializer<Index> {
        private static final long serialVersionUID = 4814086994004868202L;

        public Serializer() {
            this(null);
        }

        public Serializer(Class<Index> t) {
            super(t);
        }

        public void serialize(Index index, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeNumberField(index.getKey(), index.getOrder().value());
            gen.writeEndObject();
        }
    }

    public static enum Order {
        ASCENDING(1),
        DESCENDING(-1);

        private int value;

        private Order(int value) {
            this.value = value;
        }

        @JsonValue
        public int value() {
            return this.value;
        }

        @JsonCreator
        public static Order fromInt(int i) {
            switch (i) {
                case 1: {
                    return ASCENDING;
                }
                case -1: {
                    return DESCENDING;
                }
            }
            throw new IllegalArgumentException("Invalid index order");
        }

        @JsonCreator
        public static Order fromString(String name) {
            return Order.valueOf(name.toUpperCase());
        }
    }
}

