/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

public class Collation {
    @JsonProperty(value="locale")
    private String locale;
    @JsonProperty(value="caseLevel")
    private Boolean caseLevel;
    @JsonProperty(value="caseFirst")
    private CaseFirst caseFirst;
    @JsonProperty(value="strength")
    private Strength strength;
    @JsonProperty(value="numericOrdering")
    private Boolean numericOrdering;
    @JsonProperty(value="alternate")
    private Alternate alternate;
    @JsonProperty(value="maxVariable")
    private MaxVariable maxVariable;
    @JsonProperty(value="normalization")
    private Boolean normalization;
    @JsonProperty(value="backwards")
    private Boolean backwards;

    public Collation(String locale, boolean caseLevel, CaseFirst caseFirst, Strength strength, boolean numericOrdering, Alternate alternate, MaxVariable maxVariable, boolean normalization, boolean backwards) {
        this.locale(locale);
        this.caseLevel(caseLevel);
        this.caseFirst(caseFirst);
        this.strength(strength);
        this.numericOrdering(numericOrdering);
        this.alternate(alternate);
        this.maxVariable(maxVariable);
        this.normalization(normalization);
        this.backwards(backwards);
    }

    public Collation() {
    }

    public Collation locale(String value) {
        this.locale = value;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public Collation caseLevel(boolean value) {
        this.caseLevel = value;
        return this;
    }

    public Boolean getCaseLevel() {
        return this.caseLevel;
    }

    public Collation caseFirst(CaseFirst value) {
        this.caseFirst = value;
        return this;
    }

    public CaseFirst getCaseFirst() {
        return this.caseFirst;
    }

    public Collation strength(Strength value) {
        this.strength = value;
        return this;
    }

    public Strength Strength() {
        return this.strength;
    }

    public Collation numericOrdering(boolean value) {
        this.numericOrdering = value;
        return this;
    }

    public Boolean numericOrdering() {
        return this.numericOrdering;
    }

    public Collation alternate(Alternate value) {
        this.alternate = value;
        return this;
    }

    public Alternate alternate() {
        return this.alternate;
    }

    public Collation maxVariable(MaxVariable value) {
        this.maxVariable = value;
        return this;
    }

    public MaxVariable maxVariable() {
        return this.maxVariable;
    }

    public Collation normalization(boolean value) {
        this.normalization = value;
        return this;
    }

    public Boolean normalization() {
        return this.normalization;
    }

    public Collation backwards(boolean value) {
        this.backwards = value;
        return this;
    }

    public Boolean backwards() {
        return this.backwards;
    }

    public static enum MaxVariable {
        PUNCT,
        SPACE;


        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static MaxVariable fromString(String name) {
            return MaxVariable.valueOf(name.toUpperCase());
        }
    }

    public static enum Alternate {
        NON_IGNORABLE,
        SHIFTED;


        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static Alternate fromString(String name) {
            return Alternate.valueOf(name.toUpperCase());
        }
    }

    public static enum Strength {
        PRIMARY(1),
        SECONDARY(2),
        TERTIARY(3),
        QUATERNARY(4),
        IDENTICAL(5);

        private int value;

        private Strength(int value) {
            this.value = value;
        }

        @JsonValue
        public int value() {
            return this.value;
        }

        @JsonCreator
        public static Strength fromInt(int i) {
            switch (i) {
                case 1: {
                    return PRIMARY;
                }
                case 2: {
                    return SECONDARY;
                }
                case 3: {
                    return TERTIARY;
                }
                case 4: {
                    return QUATERNARY;
                }
                case 5: {
                    return IDENTICAL;
                }
            }
            throw new IllegalArgumentException("Invalid strength");
        }
    }

    public static enum CaseFirst {
        UPPER,
        LOWER,
        OFF;


        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static CaseFirst fromString(String name) {
            return CaseFirst.valueOf(name.toUpperCase());
        }
    }
}

