/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive.connection;

import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.elastos.hive.connection.HeaderInterceptor;
import org.elastos.hive.connection.NetworkLogInterceptor;
import org.elastos.hive.connection.NobodyConverterFactory;
import org.elastos.hive.connection.StringConverterFactory;
import org.elastos.hive.connection.model.BaseServiceConfig;
import org.elastos.hive.utils.LogUtil;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class BaseServiceUtil {
    private static final int DEFAULT_TIMEOUT = 30;

    BaseServiceUtil() {
    }

    static <S> S createService(Class<S> serviceClass, @NotNull String baseUrl, BaseServiceConfig baseServiceConfig) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS);
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)StringConverterFactory.create()).addConverterFactory((Converter.Factory)NobodyConverterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        clientBuilder.interceptors().clear();
        if (baseServiceConfig != null && baseServiceConfig.getHeaderConfig() != null) {
            HeaderInterceptor headerInterceptor = new HeaderInterceptor(baseServiceConfig.getHeaderConfig());
            clientBuilder.interceptors().add(headerInterceptor);
        }
        if (LogUtil.debug) {
            NetworkLogInterceptor networkLogInterceptor = new NetworkLogInterceptor();
            clientBuilder.interceptors().add(networkLogInterceptor);
        }
        OkHttpClient client = clientBuilder.build();
        Retrofit retrofit = retrofitBuilder.client(client).build();
        return (S)retrofit.create(serviceClass);
    }
}

